package com.patzn.lims.frame.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.frame.entity.LmsFrameCheckPlan;
import com.patzn.lims.frame.entity.LmsFrameFile;
import com.patzn.lims.frame.vo.LmsFrameCheckPlanVO;
import com.patzn.lims.workflow.FlowProcess;

import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <p>
 * 管理评审计划 服务类
 * </p>
 *
 * @author patzn123
 * @since 2018-01-09
 */
public interface ILmsFrameCheckPlanService extends IBaseService<LmsFrameCheckPlan> {

    Page<LmsFrameCheckPlan> page(Page<LmsFrameCheckPlan> page, LmsFrameCheckPlan lmsFrameCheckPlan);

    List<LmsFrameCheckPlan> list(LmsFrameCheckPlan lmsFrameCheckPlan);

    LmsFrameCheckPlanVO getVOById(Long id);

    LmsFrameCheckPlanVO getTempVO();

    boolean edit(LmsFrameCheckPlan lmsFrameCheckPlan);

    boolean add(LmsFrameCheckPlan lmsFrameCheckPlan);

    boolean delete(Long[] ids);

    LmsFrameFile uploadFile(MultipartFile file, LmsFrameCheckPlan lmsFrameCheckPlan);

    void downloadFile(Long id, HttpServletResponse response);

    boolean deleteFile(Long id);

    boolean submit(List<Long> ids);


    List<FlowProcess> submitCheckFlow(Long[] ids, Account account);


    boolean approveFlow(String taskId, String status, String reason);
}
