package com.patzn.lims.frame.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.frame.entity.LmsFrameCheckReport;
import com.patzn.lims.frame.entity.LmsFrameFile;
import com.patzn.lims.frame.vo.LmsFrameCheckReportVO;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <p>
 * 管理评审报告表 服务类
 * </p>
 *
 * @author patzn123
 * @since 2018-01-09
 */
public interface ILmsFrameCheckReportService extends IBaseService<LmsFrameCheckReport> {


    Page<LmsFrameCheckReport> page(Page<LmsFrameCheckReport> page, LmsFrameCheckReport lmsFrameCheckReport);


    List<LmsFrameCheckReport> list(LmsFrameCheckReport lmsFrameCheckReport);


    LmsFrameCheckReportVO getVOById(Long id);


    LmsFrameCheckReportVO getTempVO();


    boolean edit(LmsFrameCheckReport lmsFrameCheckReport);


    boolean add(LmsFrameCheckReport lmsFrameCheckReport);


    boolean delete(Long[] ids);


    LmsFrameFile uploadFile(MultipartFile file, LmsFrameCheckReport lmsFrameCheckReport);


    void downloadFile(Long id, HttpServletResponse response);


    boolean deleteFile(Long id);


    boolean submit(List<Long> longs);


    boolean existByIds(Long[] ids);
}
