package com.patzn.lims.frame.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.frame.dto.LmsFrameComplaintRegisterDTO;
import com.patzn.lims.frame.entity.LmsFrameComplaintRegister;
import com.patzn.lims.frame.entity.LmsFrameFile;
import com.patzn.lims.frame.vo.LmsFrameComplaintRegisterVO;
import com.patzn.lims.workflow.FlowProcess;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <p>
 * 投/申诉登记 服务类
 * </p>
 *
 * @author patzn123
 * @since 2018-01-09
 */
public interface ILmsFrameComplaintRegisterService extends IBaseService<LmsFrameComplaintRegister> {


    Page<LmsFrameComplaintRegister> page(Page<LmsFrameComplaintRegister> page, LmsFrameComplaintRegisterDTO lmsFrameComplaintRegisterDTO);


    List<LmsFrameComplaintRegister> list(LmsFrameComplaintRegister lmsFrameComplaintRegister);

    LmsFrameComplaintRegisterVO getVOById(Long id);

    LmsFrameComplaintRegisterVO getTempVO();

    Boolean edit(LmsFrameComplaintRegister lmsFrameComplaintRegister);

    boolean add(LmsFrameComplaintRegister lmsFrameComplaintRegister);

    Boolean delete(Long[] ids);

    LmsFrameFile uploadFile(MultipartFile file, LmsFrameComplaintRegister lmsFrameComplaintRegister);

    void downloadFile(Long id, HttpServletResponse response);

    Boolean deleteFile(Long id);

    Boolean submit(List<Long> longs);


    List<FlowProcess> submitCheckFlow(Long[] ids, Account account);

    boolean approveFlow(String taskId, String status, String reason);
}
