package com.patzn.lims.frame.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.frame.dto.LmsFrameCustomerInvestigateDTO;
import com.patzn.lims.frame.entity.LmsFrameCustomerInvestigate;
import com.patzn.lims.frame.entity.LmsFrameFile;
import com.patzn.lims.frame.vo.LmsFrameCustomerInvestigateVO;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <p>
 * 客户满意度管理 服务类
 * </p>
 *
 * @author patzn123
 * @since 2018-01-09
 */
public interface ILmsFrameCustomerInvestigateService extends IBaseService<LmsFrameCustomerInvestigate> {

    Page<LmsFrameCustomerInvestigate> page(Page<LmsFrameCustomerInvestigate> page, LmsFrameCustomerInvestigateDTO lmsFrameCustomerInvestigateDTO);

    List<LmsFrameCustomerInvestigate> list(LmsFrameCustomerInvestigate lmsFrameCustomerInvestigate);

    LmsFrameCustomerInvestigateVO getVOById(Long id);

    LmsFrameCustomerInvestigateVO getTempVO();

    Boolean edit(LmsFrameCustomerInvestigate lmsFrameCustomerInvestigate, Account account);

    Boolean add(LmsFrameCustomerInvestigate lmsFrameCustomerInvestigate);

    Boolean delete(Long[] ids);

    LmsFrameFile uploadFile(MultipartFile file, LmsFrameCustomerInvestigate lmsFrameCustomerInvestigate);

    void downloadFile(Long id, HttpServletResponse response);

    Boolean deleteFile(Long id);

    Boolean submit(List<Long> longs);

    void exportCustomerSatisfaction(HttpServletResponse response, Long id);
}
