package com.patzn.lims.frame.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.frame.entity.LmsFrameFile;
import com.patzn.lims.frame.entity.LmsFrameInnerCheckPlan;
import com.patzn.lims.frame.vo.LmsFrameInnerCheckPlanVO;
import com.patzn.lims.workflow.FlowProcess;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author patzn123
 * @since 2018-01-09
 */
public interface ILmsFrameInnerCheckPlanService extends IBaseService<LmsFrameInnerCheckPlan> {


    Page<LmsFrameInnerCheckPlan> page(Page<LmsFrameInnerCheckPlan> page, LmsFrameInnerCheckPlanVO lmsFrameInnerCheckPlan);


    List<LmsFrameInnerCheckPlan> list(LmsFrameInnerCheckPlan lmsFrameInnerCheckPlan);


    LmsFrameInnerCheckPlanVO getVOById(Long id);


    LmsFrameInnerCheckPlanVO getTempVO();


    Boolean edit(LmsFrameInnerCheckPlan lmsFrameInnerCheckPlan);


    Boolean add(LmsFrameInnerCheckPlan lmsFrameInnerCheckPlan);


    Boolean delete(Long[] ids);


    LmsFrameFile uploadFile(MultipartFile file, LmsFrameInnerCheckPlan lmsFrameInnerCheckPlan);

    void downloadFile(Long id, HttpServletResponse response);


    Boolean deleteFile(Long id);


    Boolean submit(List<Long> longs);


    List<FlowProcess> submitInnerCheckFlow(Long[] ids);


    boolean approveFlow(String taskId, String status, String reason);
}
