package com.patzn.lims.frame.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.frame.entity.LmsFrameFile;
import com.patzn.lims.frame.entity.LmsFrameInnerCheckReport;
import com.patzn.lims.frame.vo.LmsFrameInnerCheckReportVO;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <p>
 * 内审报告表 服务类
 * </p>
 *
 * @author patzn123
 * @since 2018-01-09
 */
public interface ILmsFrameInnerCheckReportService extends IBaseService<LmsFrameInnerCheckReport> {

    Page<LmsFrameInnerCheckReport> page(Page<LmsFrameInnerCheckReport> page, LmsFrameInnerCheckReport lmsFrameInnerCheckReport);

    List<LmsFrameInnerCheckReport> list(LmsFrameInnerCheckReport lmsFrameInnerCheckReport);

    LmsFrameInnerCheckReportVO getVOById(Long id);

    LmsFrameInnerCheckReportVO getTempVO();

    Boolean edit(LmsFrameInnerCheckReport lmsFrameInnerCheckReport);

    Boolean add(LmsFrameInnerCheckReport lmsFrameInnerCheckReport);

    Boolean delete(Long[] ids);

    LmsFrameFile uploadFile(MultipartFile file, LmsFrameInnerCheckReport lmsFrameInnerCheckReport);

    void downloadFile(Long id, HttpServletResponse response);

    Boolean deleteFile(Long id);

    Boolean submit(List<Long> longs);

    boolean existByIds(Long[] ids);
}
