package com.patzn.lims.frame.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.frame.dto.LmsFrameProblemApproveDTO;
import com.patzn.lims.frame.entity.LmsFrameProblemImprove;
import com.patzn.lims.frame.entity.LmsFrameProblemImproveAttachment;
import com.patzn.lims.frame.vo.LmsFrameProblemImproveVO;
import com.patzn.lims.workflow.FlowProcess;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <p>
 * 改进/纠正/预防措施管理 服务类
 * </p>
 *
 * @author patzn
 * @since 2018-07-18
 */
public interface ILmsFrameProblemImproveService extends IBaseService<LmsFrameProblemImprove> {


    Page<LmsFrameProblemImprove> page(Page<LmsFrameProblemImprove> page, LmsFrameProblemImprove lmsFrameProblemImprove);


    List<LmsFrameProblemImprove> list(LmsFrameProblemImprove lmsFrameProblemImprove);


    void exportItem(HttpServletResponse response, LmsFrameProblemApproveDTO dto);


    boolean submit(Long[] ids, Account account);


    boolean  updateFrameProblemImproveById(LmsFrameProblemImprove improve);

    LmsFrameProblemImproveVO getTempVO();

    LmsFrameProblemImproveAttachment uploadFile(MultipartFile file, LmsFrameProblemImproveVO lmsFrameProblemImproveVO);

    void downloadFile(Long id, HttpServletResponse response);

    boolean deleteFile(Long id);

    List<FlowProcess> submitCheckFlow(Long[] ids, Account account);

    boolean approveFlow(String taskId, String status, String reason);

    LmsFrameProblemImproveVO getVOById(Long id);

    boolean add(LmsFrameProblemImprove lmsFrameProblemImprove);

}
