package com.patzn.lims.frame.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.frame.entity.LmsMonthPlan;
import com.patzn.lims.frame.enums.PlanStatusEnum;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 年度计划子表 服务类
 * </p>
 *
 * @author patzn
 * @since 2018-06-26
 */
public interface ILmsMonthPlanService extends IBaseService<LmsMonthPlan> {


    Page<LmsMonthPlan> page(Page<LmsMonthPlan> page, LmsMonthPlan lmsMonthPlan, Date startDate, Date endDate);


    List<LmsMonthPlan> list(LmsMonthPlan lmsMonthPlan);


    Page<LmsMonthPlan> pagePlan(Page<LmsMonthPlan> page, Long planId);


    boolean copy(LmsMonthPlan lmsMonthPlan);


    boolean submit(Long[] ids, Date endDate);


    Page<LmsMonthPlan> pageReport(Page<LmsMonthPlan> page, Long planId);


    /**
     * <p>
     * 评定计划导出列表数据
     * </p>
     *
     * @param ids
     */
    void exportMonthPlan(Long[] ids, HttpServletResponse response);


    /**
     * <p>
     * 评定报告导出
     * </p>
     *
     * @param ids
     * @param response
     */
    void exportMonthReport(Long[] ids, HttpServletResponse response);


    /**
     * <p>
     * 导入计划
     * </p>
     *
     * @param file
     * @param planId
     * @param account
     * @return
     */
    boolean importMonthPlan(MultipartFile file, Long planId, Account account);

  
    boolean updateMonthPlanByYearPlan(Long yearId, PlanStatusEnum status);


    boolean updatePlanById(LmsMonthPlan lmsMonthPlan);
}
