package com.patzn.lims.frame.service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.frame.entity.LmsQcMainPlan;
import com.patzn.lims.frame.entity.LmsQcMainPlanAttachment;
import com.patzn.lims.frame.vo.LmsQcMainPlanVO;
import com.patzn.lims.workflow.FlowProcess;


import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 内部质控计划主表 服务类
 * </p>
 *
 * @author patzn
 * @since 2018-07-09
 */
public interface ILmsQcMainPlanService extends IBaseService<LmsQcMainPlan> {


    Page<LmsQcMainPlan> page(Page<LmsQcMainPlan> page, LmsQcMainPlan lmsQcMainPlan);


    List<LmsQcMainPlan> list(LmsQcMainPlan lmsQcMainPlan);


    Page<LmsQcMainPlan> pageMainPlan(Page<LmsQcMainPlan> page, LmsQcMainPlan lmsQcMainPlan, Date startDate, Date endDate);


    boolean copy(LmsQcMainPlan lmsQcMainPlan, Account account);


    boolean removeByIds(Long[] ids);


    boolean updatePlanById(LmsQcMainPlan lmsQcMainPlan);


    List<FlowProcess> submitCheckFlow(Long[] ids, Account account);


    boolean approveFlow(String taskId, String status, String reason);


    void exportPlan(HttpServletResponse response, Long id);

    LmsQcMainPlanVO getTempVO();

    LmsQcMainPlanAttachment uploadFile(MultipartFile file, LmsQcMainPlan lmsQcMainPlan);

    Boolean deleteFile(Long id);

    LmsQcMainPlanVO getVOById(Long id);


    Boolean add(LmsQcMainPlan lmsQcMainPlan);



}
