package com.patzn.lims.frame.service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.IBaseService;
import com.patzn.lims.frame.entity.LmsYearPlan;
import com.patzn.lims.frame.entity.LmsYearPlanFile;
import com.patzn.lims.frame.vo.LmsYearPlanVO;
import com.patzn.lims.workflow.FlowProcess;
import org.springframework.web.multipart.MultipartFile;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 年度总计划表 服务类
 * </p>
 *
 * @author patzn
 * @since 2018-06-26
 */
public interface ILmsYearPlanService extends IBaseService<LmsYearPlan> {


    Page<LmsYearPlan> page(Page<LmsYearPlan> page, LmsYearPlan lmsYearPlan, Date startDate, Date endDate);


    List<LmsYearPlan> list(LmsYearPlan lmsYearPlan);


    LmsYearPlanVO getVOById(Long id);


    boolean copy(LmsYearPlan lmsYearPlan, Account account);


    Page<LmsYearPlan> pageReport(Page<LmsYearPlan> page, LmsYearPlan lmsYearPlan);


    List<FlowProcess> submitYearPlanFlow(Long[] ids);


    boolean approveFlow(String taskId, String status, String reason);


    boolean approveConfirm(String taskId, String status, String reason);


    boolean updatePlanById(LmsYearPlan lmsYearPlan);


    LmsYearPlanFile uploadFile(MultipartFile file, LmsYearPlan lmsYearPlan);


    Boolean deleteFile(Long id);


    LmsYearPlanVO getTempVO();


    Boolean add(LmsYearPlan lmsYearPlan);
}
