package com.patzn.lims.frame.service.impl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.frame.entity.LmsAbilityMainPlan;
import com.patzn.lims.frame.entity.LmsAbilityMainPlanRecord;
import com.patzn.lims.frame.enums.PlanStatusEnum;
import com.patzn.lims.frame.mapper.LmsAbilityMainPlanRecordMapper;
import com.patzn.lims.frame.service.ILmsAbilityMainPlanRecordService;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 能力计划主表操作记录表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-07-20
 */
@Service
public class LmsAbilityMainPlanRecordServiceImpl extends BaseServiceImpl<LmsAbilityMainPlanRecordMapper, LmsAbilityMainPlanRecord> implements ILmsAbilityMainPlanRecordService {


    @Override
    public Page<LmsAbilityMainPlanRecord> page(Page<LmsAbilityMainPlanRecord> page, LmsAbilityMainPlanRecord lmsAbilityMainPlanRecord) {
        QueryWrapper wrapper = Wrappers.query(lmsAbilityMainPlanRecord);
        if (null != lmsAbilityMainPlanRecord.getOrigin()) {
            wrapper.like("origin", lmsAbilityMainPlanRecord.getOrigin());
            lmsAbilityMainPlanRecord.setOrigin(null);
        }

        return page(page, wrapper);
    }


    @Override
    public List<LmsAbilityMainPlanRecord> list(LmsAbilityMainPlanRecord lmsAbilityMainPlanRecord) {
        return list(Wrappers.query(lmsAbilityMainPlanRecord));
    }

    @Override
    public boolean saveAbilityMainPlanRecordByIds(LmsAbilityMainPlan plan, PlanStatusEnum fromStatus, Integer type, Long[] ids, String reason) {
        List<LmsAbilityMainPlanRecord> recordList = new ArrayList<>();
        for (Long id : ids) {
            LmsAbilityMainPlanRecord record = new LmsAbilityMainPlanRecord();
            record.setMainPlanId(id);
            record.setType(type);
            record.setOperator(LoginHelper.getAccount().getUserName());
            record.setOrigin(fromStatus.getDisplay());
            record.setTarget(PlanStatusEnum.valueOf(plan.getStatus()).getDisplay());
            record.setRemark(reason);
            recordList.add(record);
        }
        return recordList.size() > 0 && super.saveBatch(recordList);
    }
}
