package com.patzn.lims.frame.service.impl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.frame.entity.LmsAbilitySubPlan;
import com.patzn.lims.frame.entity.LmsAbilitySubPlanRecord;
import com.patzn.lims.frame.enums.PlanStatusEnum;
import com.patzn.lims.frame.mapper.LmsAbilitySubPlanRecordMapper;
import com.patzn.lims.frame.service.ILmsAbilitySubPlanRecordService;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 能力计划子表操作记录表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-07-20
 */
@Service
public class LmsAbilitySubPlanRecordServiceImpl extends BaseServiceImpl<LmsAbilitySubPlanRecordMapper, LmsAbilitySubPlanRecord> implements ILmsAbilitySubPlanRecordService {


    @Override
    public Page<LmsAbilitySubPlanRecord> page(Page<LmsAbilitySubPlanRecord> page, LmsAbilitySubPlanRecord lmsAbilitySubPlanRecord) {
        QueryWrapper wrapper = Wrappers.query(lmsAbilitySubPlanRecord);
        if (null != lmsAbilitySubPlanRecord.getOrigin()) {
            wrapper.like("origin", lmsAbilitySubPlanRecord.getOrigin());
            lmsAbilitySubPlanRecord.setOrigin(null);
        }

        return page(page, wrapper);
    }


    @Override
    public List<LmsAbilitySubPlanRecord> list(LmsAbilitySubPlanRecord lmsAbilitySubPlanRecord) {
        return list(Wrappers.query(lmsAbilitySubPlanRecord));
    }

    @Override
    public boolean saveAbilitySubPlanRecordByIds(LmsAbilitySubPlan plan, PlanStatusEnum fromStatus, Integer type, Long[] ids, String reason) {
        List<LmsAbilitySubPlanRecord> recordList = new ArrayList<>();
        for (Long id : ids) {
            LmsAbilitySubPlanRecord record = new LmsAbilitySubPlanRecord();
            record.setSubPlanId(id);
            record.setType(type);
            record.setOperator(LoginHelper.getAccount().getUserName());
            if (fromStatus.getDisplay() != null) {
                record.setOrigin(fromStatus.getDisplay());
            }else{
                record.setOrigin("草稿");
            }
            record.setTarget(PlanStatusEnum.valueOf(plan.getStatus()).getDisplay());
            record.setRemark(reason);
            recordList.add(record);
        }
        return recordList.size() > 0 && super.saveBatch(recordList);
    }
}
