package com.patzn.lims.frame.service.impl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.frame.entity.LmsAbilitySubPlan;
import com.patzn.lims.frame.enums.PlanStatusEnum;
import com.patzn.lims.frame.mapper.LmsAbilitySubPlanMapper;
import com.patzn.lims.frame.service.ILmsAbilitySubPlanAttachmentService;
import com.patzn.lims.frame.service.ILmsAbilitySubPlanRecordService;
import com.patzn.lims.frame.service.ILmsAbilitySubPlanService;
import com.patzn.lims.res.service.ILmsPropertyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 能力验证计划子表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-07-19
 */
@Service
public class LmsAbilitySubPlanServiceImpl extends BaseServiceImpl<LmsAbilitySubPlanMapper, LmsAbilitySubPlan> implements ILmsAbilitySubPlanService {

    @Autowired
    private ILmsPropertyService lmsPropertyService;
    @Autowired
    private ILmsAbilitySubPlanRecordService lmsAbilitySubPlanRecordService;
    @Autowired
    private ILmsAbilitySubPlanAttachmentService lmsAbilitySubPlanAttachmentService;

    @Override
    public Page<LmsAbilitySubPlan> page(Page<LmsAbilitySubPlan> page, LmsAbilitySubPlan lmsAbilitySubPlan) {
        QueryWrapper wrapper = Wrappers.query(lmsAbilitySubPlan);
        return page(page, wrapper);
    }


    @Override
    public List<LmsAbilitySubPlan> list(LmsAbilitySubPlan lmsAbilitySubPlan) {
        return list(Wrappers.query(lmsAbilitySubPlan));
    }

    @Override
    public Page<LmsAbilitySubPlan> pageSubPlan(Page<LmsAbilitySubPlan> page, LmsAbilitySubPlan lmsAbilitySubPlan, Date startDate, Date endDate) {
        PtAssert.fail(null == lmsAbilitySubPlan || null == lmsAbilitySubPlan.getMainPlanId(), "请确认主计划");
        return page.setRecords(baseMapper.selectPageSubPlan(page, lmsAbilitySubPlan, startDate, endDate));
    }

    @Override
    public boolean copy(LmsAbilitySubPlan lmsAbilitySubPlan, Account account) {
        PtAssert.fail(null == lmsAbilitySubPlan || null == lmsAbilitySubPlan.getMainPlanId(), "请确认主计划");
        lmsAbilitySubPlan.setStatus((Integer) PlanStatusEnum.DRAFT.getValue());
        lmsAbilitySubPlan.setProgress((Integer) PlanStatusEnum.DRAFT.getValue());
        lmsAbilitySubPlan.setUname(account.getUserName());
        lmsAbilitySubPlan.setId(IdWorker.getId());
        return super.save(lmsAbilitySubPlan);
    }

    @Override
    public boolean removeByIds(Long[] ids) {
        PtAssert.fail(ArrayUtils.isEmpty(ids), "请选择计划");
        int num = super.count(Wrappers.<LmsAbilitySubPlan>query().in("id", ids).eq("status", PlanStatusEnum.DRAFT.getValue()));
        PtAssert.fail(ids.length != num, "只能删除草稿计划");
        return super.remove(Wrappers.<LmsAbilitySubPlan>query().in("id", ids));
    }

    @Override
    public boolean updatePlanById(LmsAbilitySubPlan lmsAbilitySubPlan) {
        PtAssert.fail(null == lmsAbilitySubPlan.getId(), "id不能为空");
        LmsAbilitySubPlan dbPlan = super.getById(lmsAbilitySubPlan.getId());
        String remark = lmsPropertyService.getCompareDifferent(lmsAbilitySubPlan, dbPlan, "能力验证子计划对比", "能力验证子计划修改内容：");
        if (StringUtils.isNotEmpty(remark)) {
            lmsAbilitySubPlanRecordService.saveAbilitySubPlanRecordByIds(dbPlan, PlanStatusEnum.valueOf(dbPlan.getStatus()), 2, new Long[]{dbPlan.getId()}, remark);
        }
        return super.updateById(lmsAbilitySubPlan);
    }

    @Override
    public boolean submit(Long[] ids, String result, String person, Date endDate) {
        PtAssert.fail(ArrayUtils.isEmpty(ids), "请选择计划");
        PtAssert.fail(null == endDate || StringUtils.isBlank(result) || StringUtils.isBlank(person), "请录入监控结果、检测人员、和完成日期");
        List<LmsAbilitySubPlan> list = super.list(Wrappers.<LmsAbilitySubPlan>query().in("id", ids));
        for (LmsAbilitySubPlan plan : list) {
            PtAssert.fail(0 == lmsAbilitySubPlanAttachmentService.getCountByPlanId(plan.getId()), "请上传附件后再提交计划");
        }
        lmsAbilitySubPlanRecordService.saveAbilitySubPlanRecordByIds(new LmsAbilitySubPlan().setStatus((Integer) PlanStatusEnum.END.getValue()), PlanStatusEnum.DRAFT, 0, ids, "计划提交");
        return super.update(new LmsAbilitySubPlan().setStatus((Integer) PlanStatusEnum.END.getValue()).setProgress((Integer) PlanStatusEnum.END.getValue()).setMonitorResult(result)
                .setTester(person).setEndDate(endDate), Wrappers.<LmsAbilitySubPlan>query().in("id", ids));
    }

}
