package com.patzn.lims.frame.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.core.oss.OssClient;
import com.patzn.lims.frame.entity.LmsFrameCheckReport;
import com.patzn.lims.frame.entity.LmsFrameFile;
import com.patzn.lims.frame.entity.LmsFrameLog;
import com.patzn.lims.frame.enums.FrameFileTypeEnum;
import com.patzn.lims.frame.mapper.LmsFrameCheckReportMapper;
import com.patzn.lims.frame.service.ILmsFrameCheckReportService;
import com.patzn.lims.frame.service.ILmsFrameFileService;
import com.patzn.lims.frame.service.ILmsFrameLogService;
import com.patzn.lims.frame.vo.LmsFrameCheckReportVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 管理评审报告表 服务实现类
 * </p>
 *
 * @author patzn123
 * @since 2018-01-09
 */
@Service
public class LmsFrameCheckReportServiceImpl extends BaseServiceImpl<LmsFrameCheckReportMapper, LmsFrameCheckReport> implements ILmsFrameCheckReportService {

    @Autowired
    private ILmsFrameFileService lmsFrameFileService;
    @Autowired
    private ILmsFrameLogService lmsFrameLogService;
    @Autowired
    private OssClient ossClient;

    @Override
    public Page<LmsFrameCheckReport> page(Page<LmsFrameCheckReport> page, LmsFrameCheckReport lmsFrameCheckReport) {
        lmsFrameCheckReport.setTempStatus(1);
        return page(page, Wrappers.<LmsFrameCheckReport>query(lmsFrameCheckReport));
    }


    @Override
    public List<LmsFrameCheckReport> list(LmsFrameCheckReport lmsFrameCheckReport) {
        lmsFrameCheckReport.setTempStatus(1);
        return list(Wrappers.<LmsFrameCheckReport>query(lmsFrameCheckReport));
    }

    @Override
    public LmsFrameCheckReportVO getVOById(Long id) {
        LmsFrameCheckReport frameCheckReport = getById(id);
        if (null == frameCheckReport) {
            return null;
        }
        //获取附件
        LmsFrameCheckReportVO vo = frameCheckReport.convert(LmsFrameCheckReportVO.class);
        LmsFrameFile lmsFrameFile = new LmsFrameFile();
        lmsFrameFile.setRelId(frameCheckReport.getId());
        List<LmsFrameFile> lmsFrameFileList = lmsFrameFileService.list(lmsFrameFile);
        for (LmsFrameFile e:lmsFrameFileList) {
            e.setFilePath(ossClient.getUrl(e.getFilePath()).toString());
        }
        vo.setLmsFrameFileList(lmsFrameFileList);
        return vo;
    }

    @Override
    public LmsFrameCheckReportVO getTempVO() {
        LmsFrameCheckReport entity = new LmsFrameCheckReport();
        entity.setUserId(LoginHelper.getAccount().getUserId());
        entity.setTempStatus(0);
        LmsFrameCheckReport lmsFrameCheckReport = baseMapper.selectOne(Wrappers.query(entity));
        if (null != lmsFrameCheckReport) {
            LmsFrameCheckReportVO vo = lmsFrameCheckReport.convert(LmsFrameCheckReportVO.class);
            //获取附件
            LmsFrameFile lmsFrameFile = new LmsFrameFile();
            lmsFrameFile.setRelId(lmsFrameCheckReport.getId());
            vo.setLmsFrameFileList(lmsFrameFileService.list(lmsFrameFile));
            return vo;
        }


        LmsFrameCheckReport report = new LmsFrameCheckReport();
        report.setTempStatus(0);
        report.setStatus(0);
        report.setUserId(LoginHelper.getAccount().getUserId());
        if (save(report)) {
            LmsFrameCheckReportVO  vo = new LmsFrameCheckReportVO();
            vo.setTempStatus(report.getTempStatus());
            vo.setUserId(report.getUserId());
            vo.setId(report.getId());
            return vo;
        }
        return null;
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean edit(LmsFrameCheckReport lmsFrameCheckReport) {
        if (null != lmsFrameCheckReport.getId()) {
            //提交数据操作日志保存
            LmsFrameCheckReport entity = getById(lmsFrameCheckReport.getId());
            if (1 == entity.getStatus()) {
                LmsFrameLog log = new LmsFrameLog();
                log.setUserId(LoginHelper.getAccount().getUserId());
                log.setUserName(LoginHelper.getAccount().getUserName());
                log.setTableName("lms_frame_check_report");
                log.setOrginParams(entity.toString());
                log.setParams(lmsFrameCheckReport.toString());
                log.setCreateTime(new Date());
                lmsFrameLogService.save(log);
            }
        }
        return updateById(lmsFrameCheckReport);
    }


    @Override
    public boolean add(LmsFrameCheckReport lmsFrameCheckReport) {
        LmsFrameCheckReport entity = new LmsFrameCheckReport();
        lmsFrameCheckReport.setUserId(LoginHelper.getAccount().getUserId());
        lmsFrameCheckReport.setUserName(LoginHelper.getAccount().getUserName());
        lmsFrameCheckReport.setCreateTime(new Date());
        entity.setTempStatus(0);
        LmsFrameCheckReport temp = baseMapper.selectOne(Wrappers.query(entity));
        if (null != temp) {
            lmsFrameCheckReport.setId(temp.getId());
            lmsFrameCheckReport.setTempStatus(1);
            return updateById(lmsFrameCheckReport);
        }
        lmsFrameCheckReport.setUserId(LoginHelper.getAccount().getUserId());
        lmsFrameCheckReport.setTempStatus(1);
        return save(lmsFrameCheckReport);
    }


    @Override
    public boolean delete(Long[] ids) {
        lmsFrameFileService.deleteBatch(ids);
        return remove(Wrappers.<LmsFrameCheckReport>query().in("id", ids));
    }


    @Override
    public LmsFrameFile uploadFile(MultipartFile file, LmsFrameCheckReport lmsFrameCheckReport) {
        Long companyId = LoginHelper.getAccount().getCompanyId();
        String folderPath = "frame/InnerCheckReport/" + companyId + "/";
        return lmsFrameFileService.saveAndUpload(file, "lims", folderPath, lmsFrameCheckReport.getId(), FrameFileTypeEnum.CHECK_REPORT.getValue());
    }

    @Override
    public void downloadFile(Long id, HttpServletResponse response) {
        LmsFrameFile lmsFrameFile = lmsFrameFileService.getById(id);
        String fileUrl = lmsFrameFile.getFilePath();
        String orgFileName = lmsFrameFile.getOrginName().replaceAll("\\s*", "");
        lmsFrameFileService.downloadFile(response, "lims", fileUrl, orgFileName);
    }


    @Override
    public boolean deleteFile(Long id) {
        return lmsFrameFileService.deleteBatch(new Long[]{id});
    }


    @Override
    public boolean submit(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return false;
        }
        return updateBatchById(ids.stream().map(id -> {
            LmsFrameCheckReport entity = new LmsFrameCheckReport();
            entity.setId(id);
            entity.setStatus(1);
            return entity;
        }).collect(Collectors.toList()));
    }


    @Override
    public boolean existByIds(Long[] ids) {
        return super.count(Wrappers.<LmsFrameCheckReport>query().in("check_plan_id", ids)) >= 1;
    }
}
