package com.patzn.lims.frame.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.frame.dto.LmsFrameComplaintManageDTO;
import com.patzn.lims.frame.entity.LmsFrameComplaintManage;
import com.patzn.lims.frame.entity.LmsFrameFile;
import com.patzn.lims.frame.entity.LmsFrameLog;
import com.patzn.lims.frame.mapper.LmsFrameComplaintManageMapper;
import com.patzn.lims.frame.service.ILmsFrameComplaintManageService;
import com.patzn.lims.frame.service.ILmsFrameFileService;
import com.patzn.lims.frame.service.ILmsFrameLogService;
import com.patzn.lims.frame.vo.LmsFrameComplaintManageVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author patzn123
 * @since 2018-01-09
 */
@Service
public class LmsFrameComplaintManageServiceImpl extends BaseServiceImpl<LmsFrameComplaintManageMapper, LmsFrameComplaintManage> implements ILmsFrameComplaintManageService {

    @Autowired
    private ILmsFrameLogService lmsFrameLogService;
    @Autowired
    private ILmsFrameFileService lmsFrameFileService;

    @Override
    public Page<LmsFrameComplaintManageVO> pageVO(Page<LmsFrameComplaintManageVO> page, LmsFrameComplaintManageDTO lmsFrameComplaintManageDTO) {
        return page.setRecords(baseMapper.selectPageVO(page, lmsFrameComplaintManageDTO));
    }


    @Override
    public List<LmsFrameComplaintManage> list(LmsFrameComplaintManage lmsFrameComplaintManage) {
        return this.list(Wrappers.<LmsFrameComplaintManage>query(lmsFrameComplaintManage));
    }

    @Override
    public LmsFrameComplaintManageVO getVOById(Long id) {
        LmsFrameComplaintManageVO vo = baseMapper.selectVOById(id);
        if (null != vo) {
            //获取附件
            LmsFrameFile lmsFrameFile = new LmsFrameFile();
            lmsFrameFile.setRelId(vo.getComplaintId());
            vo.setLmsFrameFileList(lmsFrameFileService.list(lmsFrameFile));
        }
        return vo;
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean edit(LmsFrameComplaintManage lmsFrameComplaintManage) {
        if (null != lmsFrameComplaintManage.getId()) {
            //提交数据操作日志保存
            LmsFrameComplaintManage entity = getById(lmsFrameComplaintManage.getId());
            if (1 == entity.getStatus()) {
                LmsFrameLog log = new LmsFrameLog();
                log.setUserId(LoginHelper.getAccount().getUserId());
                log.setUserName(LoginHelper.getAccount().getUserName());
                log.setTableName("lms_frame_complaint_manage");
                log.setOrginParams(entity.toString());
                log.setParams(lmsFrameComplaintManage.toString());
                log.setCreateTime(new Date());
                lmsFrameLogService.save(log);
            }
        }
        return updateById(lmsFrameComplaintManage);
    }


    @Override
    public boolean submit(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return false;
        }
        return updateBatchById(ids.stream().map(id -> {
            LmsFrameComplaintManage entity = new LmsFrameComplaintManage();
            entity.setId(id);
            entity.setStatus(1);
            return entity;
        }).collect(Collectors.toList()));
    }


    @Override
    public boolean existByIds(Long[] ids) {
        return super.count(Wrappers.<LmsFrameComplaintManage>query().in("complaint_id", ids)) >= 1;
    }
}
