package com.patzn.lims.frame.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.cloud.commons.api.RestAssert;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.frame.entity.LmsFrameComplaintRegisterRecord;
import com.patzn.lims.frame.mapper.LmsFrameComplaintRegisterRecordMapper;
import com.patzn.lims.frame.service.ILmsFrameComplaintRegisterRecordService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 投申述登记操作记录表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-07-18
 */
@Service
public class LmsFrameComplaintRegisterRecordServiceImpl extends BaseServiceImpl<LmsFrameComplaintRegisterRecordMapper, LmsFrameComplaintRegisterRecord> implements ILmsFrameComplaintRegisterRecordService {


    @Override
    public Page<LmsFrameComplaintRegisterRecord> page(Page<LmsFrameComplaintRegisterRecord> page, LmsFrameComplaintRegisterRecord lmsFrameComplaintRegisterRecord) {
        RestAssert.fail(null==lmsFrameComplaintRegisterRecord.getComplaintId(),"投申述id不能为空");
         QueryWrapper wrapper = Wrappers.<LmsFrameComplaintRegisterRecord>query(lmsFrameComplaintRegisterRecord);

        return this.page(page, wrapper);
    }


    @Override
    public List<LmsFrameComplaintRegisterRecord> list(LmsFrameComplaintRegisterRecord lmsFrameComplaintRegisterRecord) {
        return this.list(Wrappers.<LmsFrameComplaintRegisterRecord>query(lmsFrameComplaintRegisterRecord));
    }
}
