package com.patzn.lims.frame.service.impl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.res.service.ILmsPropertyService;
import com.patzn.lims.frame.entity.LmsFrameCustomerInvestigateDetail;
import com.patzn.lims.frame.entity.LmsFrameCustomerInvestigateDetailRecord;
import com.patzn.lims.frame.entity.LmsFrameLog;
import com.patzn.lims.frame.mapper.LmsFrameCustomerInvestigateDetailMapper;
import com.patzn.lims.frame.service.ILmsFrameCustomerInvestigateDetailRecordService;
import com.patzn.lims.frame.service.ILmsFrameCustomerInvestigateDetailService;
import com.patzn.lims.frame.service.ILmsFrameLogService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author patzn123
 * @since 2018-01-09
 */
@Service
public class LmsFrameCustomerInvestigateDetailServiceImpl extends BaseServiceImpl<LmsFrameCustomerInvestigateDetailMapper, LmsFrameCustomerInvestigateDetail> implements ILmsFrameCustomerInvestigateDetailService {

    @Autowired
    private ILmsFrameLogService lmsFrameLogService;
    @Autowired
    private ILmsPropertyService lmsPropertyService;
    @Autowired
    private ILmsFrameCustomerInvestigateDetailRecordService lmsFrameCustomerInvestigateDetailRecordService;


    @Override
    public Page<LmsFrameCustomerInvestigateDetail> page(Page<LmsFrameCustomerInvestigateDetail> page, LmsFrameCustomerInvestigateDetail lmsFrameCustomerInvestigateDetail) {
         QueryWrapper wrapper = Wrappers.<LmsFrameCustomerInvestigateDetail>query(lmsFrameCustomerInvestigateDetail);
         if (StringUtils.isNotBlank(lmsFrameCustomerInvestigateDetail.getInvestigateItem())){
             wrapper.like("investigate_item",lmsFrameCustomerInvestigateDetail.getInvestigateItem());
             lmsFrameCustomerInvestigateDetail.setInvestigateItem(null);
         }
        return this.page(page, wrapper);
    }


    @Override
    public List<LmsFrameCustomerInvestigateDetail> list(LmsFrameCustomerInvestigateDetail lmsFrameCustomerInvestigateDetail) {
        return this.list(Wrappers.<LmsFrameCustomerInvestigateDetail>query(lmsFrameCustomerInvestigateDetail));
    }

    @Override
    public List<LmsFrameCustomerInvestigateDetail> listByInvestigateId(Long id) {
        return super.list(Wrappers.<LmsFrameCustomerInvestigateDetail>query().eq("investigate_id",id).orderBy(true,true,"item_type"));
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean edit(LmsFrameCustomerInvestigateDetail lmsFrameCustomerInvestigateDetail) {
        if (null != lmsFrameCustomerInvestigateDetail.getId()) {
            //提交数据操作日志保存
            LmsFrameCustomerInvestigateDetail entity = getById(lmsFrameCustomerInvestigateDetail.getId());

            String remark=  lmsPropertyService.getObjectCompareDifferent(lmsFrameCustomerInvestigateDetail,entity,"客户满意度调查项目对比","信息修改：");
            if (StringUtils.isNotBlank(remark)){

                LmsFrameCustomerInvestigateDetailRecord investigateDetailRecord=new LmsFrameCustomerInvestigateDetailRecord();
                investigateDetailRecord.setType(2);
                investigateDetailRecord.setInvestigateDetailId(entity.getId());
                investigateDetailRecord.setLiable(LoginHelper.getAccount().getUserName());
                investigateDetailRecord.setOrigin(LoginHelper.getAccount().getUserName());
                investigateDetailRecord.setRemark(remark);
                investigateDetailRecord.setOrigin(entity.getStatus().equals(0)?"草稿":"已提交");
                investigateDetailRecord.setTarget(entity.getStatus().equals(0)?"草稿":"已提交");
                lmsFrameCustomerInvestigateDetailRecordService.save(investigateDetailRecord);
            }
            if (1 == entity.getStatus()) {
                LmsFrameLog log = new LmsFrameLog();
                log.setUserId(LoginHelper.getAccount().getUserId());
                log.setUserName(LoginHelper.getAccount().getUserName());
                log.setTableName("lms_frame_customer_investigate_detail");
                log.setOrginParams(entity.toString());
                log.setParams(lmsFrameCustomerInvestigateDetail.toString());
                log.setCreateTime(new Date());
                lmsFrameLogService.save(log);
            }
        }
        return updateById(lmsFrameCustomerInvestigateDetail);
    }


    @Override
    public boolean submit(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return false;
        }
        return updateBatchById(ids.stream().map(id -> {
            LmsFrameCustomerInvestigateDetail fci = new LmsFrameCustomerInvestigateDetail();
            fci.setId(id);
            fci.setStatus(1);
            return fci;
        }).collect(Collectors.toList()));
    }

    @Override
    public boolean existByIds(Long[] ids) {
        return super.count(Wrappers.<LmsFrameCustomerInvestigateDetail>query().in("investigate_id", ids)) >= 1;
    }
}
