package com.patzn.lims.frame.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.frame.entity.LmsFrameCustomerInvestigateRecord;
import com.patzn.lims.frame.mapper.LmsFrameCustomerInvestigateRecordMapper;
import com.patzn.lims.frame.service.ILmsFrameCustomerInvestigateRecordService;
import com.patzn.lims.sys.service.ISysUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 内审计划操作记录表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-07-19
 */
@Service
public class LmsFrameCustomerInvestigateRecordServiceImpl extends BaseServiceImpl<LmsFrameCustomerInvestigateRecordMapper, LmsFrameCustomerInvestigateRecord> implements ILmsFrameCustomerInvestigateRecordService {

    @Autowired
    private ISysUserService sysUserClient;


    @Override
    public Page<LmsFrameCustomerInvestigateRecord> page(Page<LmsFrameCustomerInvestigateRecord> page, LmsFrameCustomerInvestigateRecord lmsFrameCustomerInvestigateRecord) {
         QueryWrapper wrapper = Wrappers.<LmsFrameCustomerInvestigateRecord>query(lmsFrameCustomerInvestigateRecord);
        wrapper.orderBy(true,true,"ctime");
        List<LmsFrameCustomerInvestigateRecord> list = this.page(page, wrapper).getRecords();
        list.forEach(e->{
            //e.setOperator(sysUserClient.get(e.getUid()).servcieData().getRealname());
            e.setOperator(e.getLiable());
        });
        return  page.setRecords(list);
    }


    @Override
    public List<LmsFrameCustomerInvestigateRecord> list(LmsFrameCustomerInvestigateRecord lmsFrameCustomerInvestigateRecord) {
        return this.list(Wrappers.<LmsFrameCustomerInvestigateRecord>query(lmsFrameCustomerInvestigateRecord));
    }
}
