package com.patzn.lims.frame.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.core.oss.OssClient;
import com.patzn.lims.frame.entity.LmsFrameFile;
import com.patzn.lims.frame.entity.LmsFrameInnerCheckReport;
import com.patzn.lims.frame.entity.LmsFrameLog;
import com.patzn.lims.frame.enums.FrameFileTypeEnum;
import com.patzn.lims.frame.mapper.LmsFrameInnerCheckReportMapper;
import com.patzn.lims.frame.service.ILmsFrameFileService;
import com.patzn.lims.frame.service.ILmsFrameInnerCheckReportService;
import com.patzn.lims.frame.service.ILmsFrameLogService;
import com.patzn.lims.frame.vo.LmsFrameInnerCheckReportVO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 内审报告表 服务实现类
 * </p>
 *
 * @author patzn123
 * @since 2018-01-09
 */
@Service
public class LmsFrameInnerCheckReportServiceImpl extends BaseServiceImpl<LmsFrameInnerCheckReportMapper, LmsFrameInnerCheckReport> implements ILmsFrameInnerCheckReportService {

    @Autowired
    private ILmsFrameFileService lmsFrameFileService;
    @Autowired
    private ILmsFrameLogService lmsFrameLogService;
    @Autowired
    private OssClient ossClient;
    @Override
    public Page<LmsFrameInnerCheckReport> page(Page<LmsFrameInnerCheckReport> page, LmsFrameInnerCheckReport lmsFrameInnerCheckReport) {
        lmsFrameInnerCheckReport.setTempStatus(1);
         QueryWrapper wrapper = Wrappers.query(lmsFrameInnerCheckReport);
        wrapper.like("check_report_name", lmsFrameInnerCheckReport.getCheckReportName());
        lmsFrameInnerCheckReport.setCheckReportName(null);
        wrapper.like("user_name", lmsFrameInnerCheckReport.getUserName());
        lmsFrameInnerCheckReport.setUserName(null);
        return page(page, wrapper);
    }

    @Override
    public List<LmsFrameInnerCheckReport> list(LmsFrameInnerCheckReport lmsFrameInnerCheckReport) {
        lmsFrameInnerCheckReport.setTempStatus(1);
        return list(Wrappers.query(lmsFrameInnerCheckReport));
    }

    @Override
    public LmsFrameInnerCheckReportVO getVOById(Long id) {
        LmsFrameInnerCheckReportVO lmsFrameInnerCheckReportVO = new LmsFrameInnerCheckReportVO();
        LmsFrameInnerCheckReport lmsFrameInnerCheckReport = getById(id);
        if (null != lmsFrameInnerCheckReport){
            BeanUtils.copyProperties(lmsFrameInnerCheckReport, lmsFrameInnerCheckReportVO);
            //获取附件
            LmsFrameFile lmsFrameFile = new LmsFrameFile();
            lmsFrameFile.setRelId(lmsFrameInnerCheckReport.getId());
            List<LmsFrameFile> lmsFrameFileList = lmsFrameFileService.list(lmsFrameFile);
            lmsFrameFileList.forEach(e -> {
                e.setFilePath(ossClient.getUrl(e.getFilePath()).toString());
            });
            lmsFrameInnerCheckReportVO.setLmsFrameFileList(lmsFrameFileList);
        }

        return lmsFrameInnerCheckReportVO;
    }

    @Override
    public LmsFrameInnerCheckReportVO getTempVO() {
        LmsFrameInnerCheckReportVO lmsFrameInnerCheckReportVO = new LmsFrameInnerCheckReportVO();
        LmsFrameInnerCheckReport entity = new LmsFrameInnerCheckReport();
        entity.setUserId(LoginHelper.getAccount().getUserId());
        entity.setTempStatus(0);
        LmsFrameInnerCheckReport lmsFrameInnerCheckReport = baseMapper.selectOne(Wrappers.query(entity));
        if (null != lmsFrameInnerCheckReport){
            BeanUtils.copyProperties(lmsFrameInnerCheckReport, lmsFrameInnerCheckReportVO);
            //获取附件
            LmsFrameFile lmsFrameFile = new LmsFrameFile();
            lmsFrameFile.setRelId(lmsFrameInnerCheckReport.getId());
            List<LmsFrameFile> lmsFrameFileList = lmsFrameFileService.list(lmsFrameFile);
            lmsFrameInnerCheckReportVO.setLmsFrameFileList(lmsFrameFileList);
        } else {
            LmsFrameInnerCheckReport report = new LmsFrameInnerCheckReport();
            report.setTempStatus(0);
            report.setUserId(LoginHelper.getAccount().getUserId());
            save(report);
            BeanUtils.copyProperties(report, lmsFrameInnerCheckReportVO);
        }

        return lmsFrameInnerCheckReportVO;
    }

    @Override
    @Transactional
    public Boolean edit(LmsFrameInnerCheckReport lmsFrameInnerCheckReport) {
        if (null != lmsFrameInnerCheckReport.getId()){//提交数据操作日志保存
            LmsFrameInnerCheckReport entity = getById(lmsFrameInnerCheckReport.getId());
            if (1 == entity.getStatus() ) {
                LmsFrameLog log = new LmsFrameLog();
                log.setUserId(LoginHelper.getAccount().getUserId());
                log.setUserName(LoginHelper.getAccount().getUserName());
                log.setTableName("lms_frame_inner_check_report");
                log.setOrginParams(entity.toString());
                log.setParams(lmsFrameInnerCheckReport.toString());
                log.setCreateTime(new Date());
                lmsFrameLogService.save(log);
            }
        }
        return updateById(lmsFrameInnerCheckReport);
    }

    @Override
    public Boolean add(LmsFrameInnerCheckReport lmsFrameInnerCheckReport) {
        LmsFrameInnerCheckReport entity = new LmsFrameInnerCheckReport();
        entity.setUserId(LoginHelper.getAccount().getUserId());
        entity.setTempStatus(0);
        LmsFrameInnerCheckReport temp = baseMapper.selectOne(Wrappers.query(entity));
        if (null != temp){
            lmsFrameInnerCheckReport.setId(temp.getId());
            lmsFrameInnerCheckReport.setTempStatus(1);
            updateById(lmsFrameInnerCheckReport);
        } else {
            lmsFrameInnerCheckReport.setUserId(LoginHelper.getAccount().getUserId());
            lmsFrameInnerCheckReport.setTempStatus(1);
            save(lmsFrameInnerCheckReport);
        }

        return true;
    }

    @Override
    public Boolean delete(Long[] ids) {
        lmsFrameFileService.deleteBatch(ids);
        return remove(Wrappers.<LmsFrameInnerCheckReport>query().in("id", ids));
    }

    @Override
    public LmsFrameFile uploadFile(MultipartFile file, LmsFrameInnerCheckReport lmsFrameInnerCheckReport) {
        Long companyId = LoginHelper.getAccount().getCompanyId();
        String folderPath = "frame/InnerCheckReport/" + companyId + "/";
        return lmsFrameFileService.saveAndUpload(file, "lims", folderPath, lmsFrameInnerCheckReport.getId(), FrameFileTypeEnum.INNER_CHECK_REPORT.getValue());
    }

    @Override
    public void downloadFile(Long id, HttpServletResponse response) {
        LmsFrameFile lmsFrameFile = lmsFrameFileService.getById(id);
        String fileUrl = lmsFrameFile.getFilePath();
        String orgFileName = lmsFrameFile.getOrginName().replaceAll("\\s*", "");
        lmsFrameFileService.downloadFile(response, "lims", fileUrl, orgFileName);
    }

    @Override
    public Boolean deleteFile(Long id) {
        Long[] ids = new Long[]{id};
        return lmsFrameFileService.deleteBatch(ids);
    }

    @Override
    public Boolean submit(List<Long> ids) {
        List<LmsFrameInnerCheckReport> entityList = Lists.newArrayList();
        for (Long id: ids) {
            LmsFrameInnerCheckReport entity = new LmsFrameInnerCheckReport();
            entity.setId(id);
            entity.setStatus(1);
            entityList.add(entity);
        }

        return updateBatchById(entityList);
    }

    @Override
    public boolean existByIds(Long[] ids) {
        return super.count(Wrappers.<LmsFrameInnerCheckReport>query().in("check_plan_id", ids)) >= 1;
    }
}
