package com.patzn.lims.frame.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.cloud.commons.api.RestAssert;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.core.oss.OssClient;
import com.patzn.lims.core.oss.OssFileResult;
import com.patzn.lims.frame.entity.LmsFrameProblemImproveAttachment;
import com.patzn.lims.frame.mapper.LmsFrameProblemImproveAttachmentMapper;
import com.patzn.lims.frame.service.ILmsFrameProblemImproveAttachmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * <p>
 * 改进/纠正/预防措施管理附件表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-07-18
 */
@Service
public class LmsFrameProblemImproveAttachmentServiceImpl extends BaseServiceImpl<LmsFrameProblemImproveAttachmentMapper, LmsFrameProblemImproveAttachment> implements ILmsFrameProblemImproveAttachmentService {

    @Autowired
    private OssClient ossClient;

    @Override
    public Page<LmsFrameProblemImproveAttachment> page(Page<LmsFrameProblemImproveAttachment> page, LmsFrameProblemImproveAttachment lmsFrameProblemImproveAttachment) {
         QueryWrapper wrapper = Wrappers.query(lmsFrameProblemImproveAttachment);
        return page(page, wrapper);
    }


    @Override
    public List<LmsFrameProblemImproveAttachment> list(LmsFrameProblemImproveAttachment lmsFrameProblemImproveAttachment) {
        return list(Wrappers.query(lmsFrameProblemImproveAttachment));
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean save(Long problemImproveId, MultipartFile file) {
        OssFileResult result = ossClient.upload(file);
        if (null == result) {
            return false;
        }
        // 文件类型，版本信息
        LmsFrameProblemImproveAttachment attachment = new LmsFrameProblemImproveAttachment();
        attachment.setType(result.getType());
        attachment.setProblemImproveId(problemImproveId);
        attachment.setBucketName(result.getBucketName());
        attachment.setObjectKey(result.getObjectKey());
        attachment.setVersionId(result.getVersionId());
        // 上传新文件
        int length = result.getName().length();
        if (length > 99) {
            StringBuilder fileName = new StringBuilder();
            fileName.append(result.getName().substring(0, 50));
            fileName.append(result.getName().substring(length - 50));
            attachment.setFileName(fileName.toString());
        } else {
            attachment.setFileName(result.getName());
        }
        return super.save(attachment);
    }

    @Override
    public void download(Long id, HttpServletResponse response) {
        LmsFrameProblemImproveAttachment attachment = super.getById(id);
        if (null == attachment) {
            RestAssert.fail("抱歉！该附件不存在");
        }
        ossClient.download(attachment.getObjectKey(), response);
    }

    @Override
    public LmsFrameProblemImproveAttachment saveAndUpload(MultipartFile file, String bucketName, String foldPath, Long relId, String type) {
        LmsFrameProblemImproveAttachment attachment = new LmsFrameProblemImproveAttachment();
        String fileName = file.getOriginalFilename();
        OssFileResult result = ossClient.upload(file);
        if (null == result) {
            return null;
        }
        attachment.setProblemImproveId(relId);
        attachment.setFileName(fileName);
        attachment.setObjectKey(result.getObjectKey());
        //核查类型
        attachment.setType(type);
        save(attachment);
        attachment.setObjectKey(ossClient.getUrl(attachment.getObjectKey()).toString());
        return attachment;
    }

    @Override
    public void downloadFile(HttpServletResponse response, String bucket, String fileName, String orgFileName) {
        ossClient.download(fileName, response);
    }

    @Override
    public Boolean deleteBatch(Long[] ids) {
        for (int i = 0; i < ids.length; i++) {
            LmsFrameProblemImproveAttachment attachment = getById(ids[i]);
            if (null != attachment) {
                ossClient.deleteObject(attachment.getObjectKey());
            }
        }
        return remove(Wrappers.<LmsFrameProblemImproveAttachment>query().in("id", ids));
    }
}
