package com.patzn.lims.frame.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.frame.entity.LmsFrameProblemImproveRecord;
import com.patzn.lims.frame.mapper.LmsFrameProblemImproveRecordMapper;
import com.patzn.lims.frame.service.ILmsFrameProblemImproveRecordService;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 人员培训记录操作日志表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-07-18
 */
@Service
public class LmsFrameProblemImproveRecordServiceImpl extends BaseServiceImpl<LmsFrameProblemImproveRecordMapper, LmsFrameProblemImproveRecord> implements ILmsFrameProblemImproveRecordService {


    @Override
    public Page<LmsFrameProblemImproveRecord> page(Page<LmsFrameProblemImproveRecord> page, LmsFrameProblemImproveRecord lmsFrameProblemImproveRecord) {
         QueryWrapper wrapper = Wrappers.query(lmsFrameProblemImproveRecord);
        List<LmsFrameProblemImproveRecord> list = this.page(page, wrapper).getRecords();
        list.forEach(e -> {
            if (e.getRemark() != null) {
                e.setRemark(e.getRemark().replaceAll("<[.[^<]]*>", ""));
            }
        });
        return page.setRecords(list) ;
    }


    @Override
    public List<LmsFrameProblemImproveRecord> list(LmsFrameProblemImproveRecord lmsFrameProblemImproveRecord) {
        return this.list(Wrappers.query(lmsFrameProblemImproveRecord));
    }
}
