package com.patzn.lims.frame.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.frame.entity.LmsFrameFile;
import com.patzn.lims.frame.entity.LmsFrameUnconformImprove;
import com.patzn.lims.frame.enums.FrameFileTypeEnum;
import com.patzn.lims.frame.mapper.LmsFrameUnconformImproveMapper;
import com.patzn.lims.frame.service.ILmsFrameFileService;
import com.patzn.lims.frame.service.ILmsFrameUnconformImproveService;
import com.patzn.lims.frame.vo.LmsFrameUnconformImproveVO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.List;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author patzn123
 * @since 2018-01-10
 */
@Service
public class LmsFrameUnconformImproveServiceImpl extends BaseServiceImpl<LmsFrameUnconformImproveMapper, LmsFrameUnconformImprove> implements ILmsFrameUnconformImproveService {

    @Autowired
    private ILmsFrameFileService lmsFrameFileService;

    @Override
    public Page<LmsFrameUnconformImprove> page(Page<LmsFrameUnconformImprove> page, LmsFrameUnconformImprove lmsFrameUnconformImprove) {
        lmsFrameUnconformImprove.setTempStatus(1);
         QueryWrapper wrapper = Wrappers.query(lmsFrameUnconformImprove);
        wrapper.like("question", lmsFrameUnconformImprove.getQuestion());

        lmsFrameUnconformImprove.setQuestion(null);
        return page(page, wrapper);
    }

    @Override
    public List<LmsFrameUnconformImprove> list(LmsFrameUnconformImprove lmsFrameUnconformImprove) {
        lmsFrameUnconformImprove.setTempStatus(1);
        return list(Wrappers.query(lmsFrameUnconformImprove));
    }

    @Override
    public LmsFrameUnconformImproveVO getVOById(Long id) {
        LmsFrameUnconformImproveVO lmsFrameUnconformImproveVO = new LmsFrameUnconformImproveVO();
        LmsFrameUnconformImprove lmsFrameUnconformImprove = getById(id);
        if (null != lmsFrameUnconformImprove){
            BeanUtils.copyProperties(lmsFrameUnconformImprove, lmsFrameUnconformImproveVO);
            //获取附件
            LmsFrameFile lmsFrameFile = new LmsFrameFile();
            lmsFrameFile.setRelId(lmsFrameUnconformImprove.getId());
            List<LmsFrameFile> lmsFrameFileList = lmsFrameFileService.list(lmsFrameFile);
            lmsFrameUnconformImproveVO.setLmsFrameFileList(lmsFrameFileList);
        }

        return lmsFrameUnconformImproveVO;
    }

    @Override
    public LmsFrameUnconformImproveVO getTempVO() {
        LmsFrameUnconformImproveVO lmsFrameUnconformImproveVO = new LmsFrameUnconformImproveVO();
        LmsFrameUnconformImprove entity = new LmsFrameUnconformImprove();
        entity.setUserId(LoginHelper.getAccount().getUserId());
        entity.setTempStatus(0);
        LmsFrameUnconformImprove lmsFrameUnconformImprove = baseMapper.selectOne(Wrappers.query(entity));
        if (null != lmsFrameUnconformImprove){
            BeanUtils.copyProperties(lmsFrameUnconformImprove, lmsFrameUnconformImproveVO);
            //获取附件
            LmsFrameFile lmsFrameFile = new LmsFrameFile();
            lmsFrameFile.setRelId(lmsFrameUnconformImprove.getId());
            List<LmsFrameFile> lmsFrameFileList = lmsFrameFileService.list(lmsFrameFile);
            lmsFrameUnconformImproveVO.setLmsFrameFileList(lmsFrameFileList);
        } else {
            LmsFrameUnconformImprove plan = new LmsFrameUnconformImprove();
            plan.setTempStatus(0);
            plan.setUserId(LoginHelper.getAccount().getUserId());
            save(plan);
            BeanUtils.copyProperties(plan, lmsFrameUnconformImproveVO);
        }

        return lmsFrameUnconformImproveVO;
    }

    @Override
    public Boolean add(LmsFrameUnconformImprove lmsFrameUnconformImprove) {
        lmsFrameUnconformImprove.setApplyId(LoginHelper.getAccount().getUserId());
        lmsFrameUnconformImprove.setApplyName(LoginHelper.getAccount().getUserName());
        lmsFrameUnconformImprove.setApplyTime(new Date());

        LmsFrameUnconformImprove entity = new LmsFrameUnconformImprove();
        entity.setUserId(LoginHelper.getAccount().getUserId());
        entity.setTempStatus(0);
        LmsFrameUnconformImprove temp = baseMapper.selectOne(Wrappers.query(entity));
        if (null != temp){
            lmsFrameUnconformImprove.setId(temp.getId());
            lmsFrameUnconformImprove.setTempStatus(1);
            updateById(lmsFrameUnconformImprove);
        } else {
            lmsFrameUnconformImprove.setUserId(LoginHelper.getAccount().getUserId());
            lmsFrameUnconformImprove.setTempStatus(1);
            save(lmsFrameUnconformImprove);
        }

        return true;
    }

    @Override
    public Boolean delete(Long[] ids) {
        lmsFrameFileService.deleteBatch(ids);
        return super.remove(Wrappers.<LmsFrameUnconformImprove>query().in("id", ids));
    }

    @Override
    public LmsFrameFile uploadFile(MultipartFile file, LmsFrameUnconformImprove lmsFrameUnconformImprove) {
        Long companyId = LoginHelper.getAccount().getCompanyId();
        String folderPath = "frame/UnconformImprove/" + companyId + "/";
        return lmsFrameFileService.saveAndUpload(file, "lims", folderPath, lmsFrameUnconformImprove.getId(), FrameFileTypeEnum.UN_CONFORM_IMPROVE.getValue());
    }

    @Override
    public void downloadFile(Long id, HttpServletResponse response) {
        LmsFrameFile lmsFrameFile = lmsFrameFileService.getById(id);
        String fileUrl = lmsFrameFile.getFilePath();
        String orgFileName = lmsFrameFile.getOrginName().replaceAll("\\s*", "");
        lmsFrameFileService.downloadFile(response, "lims", fileUrl, orgFileName);
    }

    @Override
    public Boolean deleteFile(Long id) {
        Long[] ids = new Long[]{id};
        return lmsFrameFileService.deleteBatch(ids);
    }

    @Override
    public Boolean submit(List<Long> ids) {
        List<LmsFrameUnconformImprove> entityList = Lists.newArrayList();
        for (Long id: ids) {
            LmsFrameUnconformImprove entity = new LmsFrameUnconformImprove();
            entity.setId(id);
            entity.setStatus(1);
            entityList.add(entity);
        }

        return updateBatchById(entityList);
    }

    @Override
    public boolean existByIds(Long[] ids) {
        return super.count(Wrappers.<LmsFrameUnconformImprove>query().in("register_id", ids)) >= 1;
    }
}
