package com.patzn.lims.frame.service.impl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.patzn.cloud.commons.api.RestAssert;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.core.oss.OssClient;
import com.patzn.lims.res.service.ILmsPropertyService;
import com.patzn.lims.frame.entity.*;
import com.patzn.lims.frame.enums.FrameFileTypeEnum;
import com.patzn.lims.frame.enums.UnconformRegisterEnum;
import com.patzn.lims.frame.mapper.LmsFrameUnconformRegisterMapper;
import com.patzn.lims.frame.service.ILmsFrameFileService;
import com.patzn.lims.frame.service.ILmsFrameUnconformImproveService;
import com.patzn.lims.frame.service.ILmsFrameUnconformRegisterRecordService;
import com.patzn.lims.frame.service.ILmsFrameUnconformRegisterService;
import com.patzn.lims.frame.vo.LmsFrameUnconformRegisterVO;
import com.patzn.lims.workflow.FlowInfo;
import com.patzn.lims.workflow.FlowProcess;
import com.patzn.lims.workflow.FlowType;
import com.patzn.lims.workflow.FlowVariables;
import com.patzn.lims.workflow.service.IFlowProcessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 不符合项登记 服务实现类
 * </p>
 *
 * @author patzn123
 * @since 2018-01-10
 */
@Service
public class LmsFrameUnconformRegisterServiceImpl extends BaseServiceImpl<LmsFrameUnconformRegisterMapper, LmsFrameUnconformRegister> implements ILmsFrameUnconformRegisterService {

    @Autowired
     private IFlowProcessService flowProcessClient;
    @Autowired
    private ILmsFrameFileService lmsFrameFileService;
    @Autowired
    private ILmsFrameUnconformImproveService lmsFrameUnconformImproveService;
    @Autowired
    private ILmsFrameUnconformRegisterRecordService lmsFrameUnconformRegisterRecordService;

    @Autowired
    private ILmsPropertyService lmsPropertyService;

    @Autowired
    private OssClient ossClient;


    @Override
    public Page<LmsFrameUnconformRegister> page(Page<LmsFrameUnconformRegister> page, LmsFrameUnconformRegister lmsFrameUnconformRegister) {
        lmsFrameUnconformRegister.setTempStatus(1);
         QueryWrapper wrapper = Wrappers.query(lmsFrameUnconformRegister);
        wrapper.like("org_name", lmsFrameUnconformRegister.getOrgName());
        wrapper.like("org_manager_name", lmsFrameUnconformRegister.getOrgManagerName());
        wrapper.like("register_name", lmsFrameUnconformRegister.getRegisterName());
        wrapper.like("org_manager_audit", lmsFrameUnconformRegister.getOrgManagerAudit());

        lmsFrameUnconformRegister.setOrgName(null);
        lmsFrameUnconformRegister.setOrgManagerName(null);
        lmsFrameUnconformRegister.setRegisterName(null);
        lmsFrameUnconformRegister.setOrgManagerAudit(null);
        wrapper.orderBy(true,true,"register_time");
        return page(page, wrapper);
    }


    @Override
    public List<LmsFrameUnconformRegister> list(LmsFrameUnconformRegister lmsFrameUnconformRegister) {
        lmsFrameUnconformRegister.setTempStatus(1);
        return list(Wrappers.query(lmsFrameUnconformRegister));
    }

    @Override
    public LmsFrameUnconformRegisterVO getVOById(Long id) {
        LmsFrameUnconformRegisterVO lmsFrameUnconformRegisterVO = new LmsFrameUnconformRegisterVO();
        LmsFrameUnconformRegister lmsFrameUnconformRegiste = getById(id);
        if (null != lmsFrameUnconformRegiste) {
            BeanUtils.copyProperties(lmsFrameUnconformRegiste, lmsFrameUnconformRegisterVO);
            //获取附件
            setLmsFrameFile(lmsFrameUnconformRegiste.getId(), lmsFrameUnconformRegisterVO);
        }

        return lmsFrameUnconformRegisterVO;
    }


    public void setLmsFrameFile(Long relId, LmsFrameUnconformRegisterVO vo) {
        LmsFrameFile lmsFrameFile = new LmsFrameFile();
        lmsFrameFile.setRelId(relId);
        List<LmsFrameFile> list = lmsFrameFileService.list(lmsFrameFile);
        for (LmsFrameFile e:list) {
            e.setFilePath(ossClient.getUrl(e.getFilePath()).toString());
        }
        vo.setLmsFrameFileList(list);
    }

    @Override
    public LmsFrameUnconformRegisterVO getTempVO() {
        LmsFrameUnconformRegisterVO lmsFrameUnconformRegisterVO = new LmsFrameUnconformRegisterVO();
        LmsFrameUnconformRegister entity = new LmsFrameUnconformRegister();
        entity.setUserId(LoginHelper.getAccount().getUserId());
        entity.setTempStatus(0);
        LmsFrameUnconformRegister lmsFrameUnconformRegister = baseMapper.selectOne(Wrappers.query(entity));
        if (null != lmsFrameUnconformRegister) {
            BeanUtils.copyProperties(lmsFrameUnconformRegister, lmsFrameUnconformRegisterVO);
            //获取附件
            setLmsFrameFile(lmsFrameUnconformRegister.getId(), lmsFrameUnconformRegisterVO);
        } else {
            LmsFrameUnconformRegister plan = new LmsFrameUnconformRegister();
            plan.setTempStatus(0);
            plan.setUserId(LoginHelper.getAccount().getUserId());
            save(plan);
            BeanUtils.copyProperties(plan, lmsFrameUnconformRegisterVO);
        }

        return lmsFrameUnconformRegisterVO;
    }

    @Override
    public Boolean add(LmsFrameUnconformRegister lmsFrameUnconformRegister) {
        lmsFrameUnconformRegister.setRegisterId(LoginHelper.getAccount().getUserId());
        lmsFrameUnconformRegister.setRegisterName(LoginHelper.getAccount().getUserName());
        lmsFrameUnconformRegister.setRegisterTime(new Date());

        LmsFrameUnconformRegister entity = new LmsFrameUnconformRegister();
        entity.setUserId(LoginHelper.getAccount().getUserId());
        entity.setTempStatus(0);
        LmsFrameUnconformRegister temp = baseMapper.selectOne(Wrappers.query(entity));
        lmsFrameUnconformRegister.setTempStatus(1);
        if (null != temp) {
            lmsFrameUnconformRegister.setId(temp.getId());
            updateById(lmsFrameUnconformRegister);
        } else {
            lmsFrameUnconformRegister.setUserId(LoginHelper.getAccount().getUserId());
            save(lmsFrameUnconformRegister);
        }
        //提交
//        if (UnconformRegisterEnum.DEPARTMENT_HEAD_ONE_CHECK.getValue().toString().equals(lmsFrameUnconformRegister.getStatus().getValue().toString())) {
//            submit(lmsFrameUnconformRegister.getId());
//        }

        return true;
    }

    @Override
    public Boolean delete(Long[] ids) {
        if (lmsFrameUnconformImproveService.existByIds(ids)) {
            RestAssert.fail("请先删除该条数据下所有的内审内容数据！");
        }

        lmsFrameFileService.deleteBatch(ids);
        return super.remove(Wrappers.<LmsFrameUnconformRegister>query().in("id", ids));
    }

    @Override
    public LmsFrameFile uploadFile(MultipartFile file, LmsFrameUnconformRegister lmsFrameUnconformRegister) {
        Long companyId = LoginHelper.getAccount().getCompanyId();
        String folderPath = "frame/UnconformRegister/" + companyId + "/";
        return lmsFrameFileService.saveAndUpload(file, "lims", folderPath, lmsFrameUnconformRegister.getId(), FrameFileTypeEnum.UN_CONFORM_REGISTER.getValue());

    }

    @Override
    public void downloadFile(Long id, HttpServletResponse response) {
        LmsFrameFile lmsFrameFile = lmsFrameFileService.getById(id);
        String fileUrl = lmsFrameFile.getFilePath();
        String orgFileName = lmsFrameFile.getOrginName().replaceAll("\\s*", "");
        lmsFrameFileService.downloadFile(response, "lims", fileUrl, orgFileName);
    }

    @Override
    public Boolean deleteFile(Long id) {
        Long[] ids = new Long[]{id};
        return lmsFrameFileService.deleteBatch(ids);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public List<FlowProcess> submit(Long[] ids, Account account) {
        if (ArrayUtils.isEmpty(ids)) {
            return null;
        }
        List<LmsFrameUnconformRegister> lmsFrameUnconformRegisterList = super.list(Wrappers.<LmsFrameUnconformRegister>query().in("id", ids));
        List<FlowInfo> flowInfoList = new ArrayList<>();
        List<LmsFrameUnconformRegisterRecord> recordList = Lists.newArrayList();
        List<LmsFrameUnconformRegister> updateList =  lmsFrameUnconformRegisterList.stream()
                .filter(lmsFrameUnconformRegister -> null != lmsFrameUnconformRegister).map(
                lmsFrameUnconformRegister->{
                    flowInfoList.add(FlowInfo.convertFlowInfo(FlowType.FRAME_UNCOMFORT_REGISTER,
                            account, lmsFrameUnconformRegister.getId(), lmsFrameUnconformRegister.getRemark()));
                // 设置状态为待审批
                LmsFrameUnconformRegister register = new LmsFrameUnconformRegister();
                register.setId(lmsFrameUnconformRegister.getId());
                register.setStatus(UnconformRegisterEnum.DEPARTMENT_HEAD_ONE_CHECK);

                LmsFrameUnconformRegisterRecord  record = new LmsFrameUnconformRegisterRecord();
                    record.setOrigin(lmsFrameUnconformRegister.getStatus().getDisplay());
                    record.setTarget(UnconformRegisterEnum.DEPARTMENT_HEAD_ONE_CHECK.getDisplay());
                    record.setUnconformId(lmsFrameUnconformRegister.getId());
                    record.setType(0);
                    record.setLiable(account.getUserName());
                    record.setOperator(account.getUserName());
                    record.setRemark("提交" + UnconformRegisterEnum.DEPARTMENT_HEAD_ONE_CHECK.getDisplay().toString());
                    recordList.add(record);
                    return register;
                }).collect(Collectors.toList());
            updateBatchById(updateList);
            if (CollectionUtils.isNotEmpty(recordList)) {
                lmsFrameUnconformRegisterRecordService.saveBatch(recordList);
            }
        return flowProcessClient.saveTask(flowInfoList,account);
      /*  try {
            LmsFrameUnconformRegister lmsFrameUnconformRegister = baseMapper.selectById(id);
            ArrayList<FlowInfo> flowInfoList = Lists.newArrayList();
            Account account = LoginHelper.getAccount();
            flowInfoList.add(FlowInfo.convertFlowInfo(FlowType.FRAME_UNCOMFORT_REGISTER,
                    account, lmsFrameUnconformRegister.getId(), lmsFrameUnconformRegister.getRemark()));
            flowProcessClient.addFlowTask(flowInfoList).servcieData();
            //更新采购单状态
            //lmsFrameUnconformRegister.setStatus(1);
            //部门负责人一次审批
            setRecord(UnconformRegisterEnum.DEPARTMENT_HEAD_ONE_CHECK, lmsFrameUnconformRegister.getStatus(),
                    lmsFrameUnconformRegister, 0, LoginHelper.getAccount().getUserName(),
                    "提交" + UnconformRegisterEnum.DEPARTMENT_HEAD_ONE_CHECK.getDisplay().toString(),
                    LoginHelper.getAccount());
            lmsFrameUnconformRegister.setStatus(UnconformRegisterEnum.DEPARTMENT_HEAD_ONE_CHECK);
            baseMapper.updateById(lmsFrameUnconformRegister);
        } catch (Exception ex) {
            RestAssert.fail("流程提交失败，原因：" + ex.getMessage());
        }

        return true;*/
    }

    private FlowInfo convertFlowInfo(LmsFrameUnconformRegister lmsFrameUnconformRegister, Account account) {
        FlowInfo flowInfo = new FlowInfo();
        flowInfo.setFlowType(FlowType.FRAME_UNCOMFORT_REGISTER.getValue());
        flowInfo.setId(lmsFrameUnconformRegister.getId());
        flowInfo.setApplyId(account.getUserIdStr());
        flowInfo.setApplyName(account.getUserName());
        flowInfo.setRemark(lmsFrameUnconformRegister.getRemark());
        flowInfo.setApplyTime(new Date());
        return flowInfo;
    }

    @Override
    public Boolean approve(String taskId, String status, String reason, String audit) {
        FlowVariables flowVariables = new FlowVariables(taskId);
        FlowInfo flowInfo = null;
        Map<String, Object> map = new HashMap<>(2);
        if ("success".equals(status)) {
            // 确认审批完成
            flowInfo = flowProcessClient.complete(taskId);
            if (null == flowInfo) {
                PtAssert.fail("确认审批失败！");
                return false;
            }
        } else if ("false".equals(status)) {
            flowInfo = flowProcessClient.complete(taskId);
        } else if ("2".equals(status)) {//部门负责人一次审批通过
            map.put(FlowInfo.APPLY_ID, LoginHelper.getAccount().getUserId());
            map.put("firstDetpDirectorGroupAuditPass", true);
            flowVariables.setVariables(map);
            flowInfo = flowProcessClient.complete(flowVariables);
        } else if ("6".equals(status)) {//部门负责人一次审批驳回
            map.put(FlowInfo.APPLY_ID, LoginHelper.getAccount().getUserId());
            map.put("firstDetpDirectorGroupAuditPass", false);
            flowVariables.setVariables(map);
            flowInfo = flowProcessClient.complete(flowVariables);
        } else if ("3".equals(status)) {//质量负责人一次审批通过
            map.put(FlowInfo.APPLY_ID, LoginHelper.getAccount().getUserId());
            map.put("firstQualityDirectorGroupAuditPass", true);
            flowVariables.setVariables(map);
            flowInfo = flowProcessClient.complete(flowVariables);
        } else if ("7".equals(status)) {//质量负责人一次审批驳回
            map.put(FlowInfo.APPLY_ID, LoginHelper.getAccount().getUserId());
            map.put("firstQualityDirectorGroupAuditPass", false);
            flowVariables.setVariables(map);
            flowInfo = flowProcessClient.complete(flowVariables);
        } else if ("4".equals(status)) {//部门负责人二次审批通过
            map.put(FlowInfo.APPLY_ID, LoginHelper.getAccount().getUserId());
            map.put("secondDetpDirectorGroupAuditPass", true);
            flowVariables.setVariables(map);
            flowInfo = flowProcessClient.complete(flowVariables);
        } else if ("8".equals(status)) {//部门负责人二次审批驳回
            map.put(FlowInfo.APPLY_ID, LoginHelper.getAccount().getUserId());
            map.put("secondDetpDirectorGroupAuditPass", false);
            flowVariables.setVariables(map);
            flowInfo = flowProcessClient.complete(flowVariables);
        } else if ("5".equals(status)) {//质量负责人二次审批通过
            map.put(FlowInfo.APPLY_ID, LoginHelper.getAccount().getUserId());
            map.put("secondQualityDirectorGroupAuditPass", true);
            flowVariables.setVariables(map);
            flowInfo = flowProcessClient.complete(flowVariables);
        } else if ("9".equals(status)) {//质量负责人二次审批驳回
            map.put(FlowInfo.APPLY_ID, LoginHelper.getAccount().getUserId());
            map.put("secondQualityDirectorGroupAuditPass", false);
            flowVariables.setVariables(map);
            flowInfo = flowProcessClient.complete(flowVariables);
        } else {
            flowInfo = null;
        }

        if (null != flowInfo) {
            Integer count = updateRegister(flowInfo, status, reason, audit);
            if (null == count) {
                return false;
            } else {
                return true;
            }
        } else {
            return false;
        }
    }

    @Override
    public boolean updateUnconformRegisterById(LmsFrameUnconformRegister lmsFrameUnconformRegister) {
        RestAssert.fail(null == lmsFrameUnconformRegister.getId(), "编辑id不能为空");
        LmsFrameUnconformRegister dbRegister = getById(lmsFrameUnconformRegister.getId());
        String remark = lmsPropertyService.getObjectCompareDifferent(lmsFrameUnconformRegister, dbRegister, "不符合项登记信息对比", "信息修改：");
        if (StringUtils.isNotBlank(remark)) {
            LmsFrameUnconformRegisterRecord registerRecord = new LmsFrameUnconformRegisterRecord();
            registerRecord.setType(2);
            registerRecord.setUnconformId(dbRegister.getId());
            registerRecord.setRemark(remark);
            registerRecord.setOperator(LoginHelper.getAccount().getUserName());
            registerRecord.setOrigin(dbRegister.getStatus().getDisplay());
            registerRecord.setTarget(dbRegister.getStatus().getDisplay());
            lmsFrameUnconformRegisterRecordService.save(registerRecord);
        }
        return updateById(lmsFrameUnconformRegister);
    }

    private Integer updateRegister(FlowInfo flowInfo, String status, String reason, String autit) {
        LmsFrameUnconformRegister lmsFrameUnconformRegister = new LmsFrameUnconformRegister();
        lmsFrameUnconformRegister.setId(flowInfo.getId());
        if ("success".equals(status) || "false".equals(status)) {
            //lmsFrameUnconformRegister.setStatus(10);
            lmsFrameUnconformRegister.setStatus(UnconformRegisterEnum.END);
            setRecord(UnconformRegisterEnum.END, lmsFrameUnconformRegister.getStatus(),
                    lmsFrameUnconformRegister, 0, LoginHelper.getAccount().getUserName(),
                    UnconformRegisterEnum.END.getDisplay().toString(),
                    LoginHelper.getAccount());

        } else if ("2".equals(status)) {//部门负责人审批通过(一审)
            //lmsFrameUnconformRegister.setStatus(2);
            lmsFrameUnconformRegister.setStatus(UnconformRegisterEnum.DEPARTMENT_HEAD_ONE_CHECK_PASS);
            setRecord(UnconformRegisterEnum.DEPARTMENT_HEAD_ONE_CHECK_PASS, lmsFrameUnconformRegister.getStatus(),
                    lmsFrameUnconformRegister, 0, LoginHelper.getAccount().getUserName(),
                    UnconformRegisterEnum.DEPARTMENT_HEAD_ONE_CHECK_PASS.getDisplay().toString() + reason,
                    LoginHelper.getAccount());
            lmsFrameUnconformRegister.setUnconformReason(reason);
            lmsFrameUnconformRegister.setOrgManagerAudit(autit);
            lmsFrameUnconformRegister.setOrgManagerTime(new Date());
        } else if ("6".equals(status)) {//部门负责人审批驳回(一审)
            //lmsFrameUnconformRegister.setStatus(6);
            lmsFrameUnconformRegister.setStatus(UnconformRegisterEnum.DEPARTMENT_HEAD_ONE_CHECK_BACK);
            setRecord(UnconformRegisterEnum.DEPARTMENT_HEAD_ONE_CHECK_BACK, lmsFrameUnconformRegister.getStatus(),
                    lmsFrameUnconformRegister, 1, lmsFrameUnconformRegister.getRegisterName(),
                    UnconformRegisterEnum.DEPARTMENT_HEAD_ONE_CHECK_BACK.getDisplay().toString() + reason,
                    LoginHelper.getAccount());

            lmsFrameUnconformRegister.setUnconformReason(reason);
            lmsFrameUnconformRegister.setOrgManagerAudit(autit);
            lmsFrameUnconformRegister.setOrgManagerTime(new Date());
        } else if ("3".equals(status)) {//质量负责人审批通过(一审)
            //lmsFrameUnconformRegister.setStatus(3);
            lmsFrameUnconformRegister.setStatus(UnconformRegisterEnum.QUALITY_HEAD_ONE_CHECK_PASS);
            setRecord(UnconformRegisterEnum.QUALITY_HEAD_ONE_CHECK_PASS, lmsFrameUnconformRegister.getStatus(),
                    lmsFrameUnconformRegister, 0, LoginHelper.getAccount().getUserName(),
                    UnconformRegisterEnum.QUALITY_HEAD_ONE_CHECK_PASS.getDisplay().toString() + reason,
                    LoginHelper.getAccount());

            lmsFrameUnconformRegister.setVerifyPlan(reason);
            lmsFrameUnconformRegister.setQualityManagerAudit(autit);
            lmsFrameUnconformRegister.setQualityManagerTime(new Date());
        } else if ("7".equals(status)) {//质量负责人审批驳回(一审)
            //lmsFrameUnconformRegister.setStatus(7);
            lmsFrameUnconformRegister.setStatus(UnconformRegisterEnum.QUALITY_HEAD_ONE_CHECK_BACK);
            setRecord(UnconformRegisterEnum.QUALITY_HEAD_ONE_CHECK_BACK, lmsFrameUnconformRegister.getStatus(),
                    lmsFrameUnconformRegister, 1, lmsFrameUnconformRegister.getRegisterName(),
                    UnconformRegisterEnum.QUALITY_HEAD_ONE_CHECK_BACK.getDisplay().toString() + reason,
                    LoginHelper.getAccount());

            lmsFrameUnconformRegister.setVerifyPlan(reason);
            lmsFrameUnconformRegister.setQualityManagerAudit(autit);
            lmsFrameUnconformRegister.setQualityManagerTime(new Date());
        } else if ("4".equals(status)) {//部门负责人审批通过(二审)
            // lmsFrameUnconformRegister.setStatus(4);
            lmsFrameUnconformRegister.setStatus(UnconformRegisterEnum.DEPARTMENT_HEAD_TWO_CHECK_PASS);
            setRecord(UnconformRegisterEnum.DEPARTMENT_HEAD_TWO_CHECK_PASS, lmsFrameUnconformRegister.getStatus(),
                    lmsFrameUnconformRegister, 0, LoginHelper.getAccount().getUserName(),
                    UnconformRegisterEnum.DEPARTMENT_HEAD_TWO_CHECK_PASS.getDisplay().toString() + reason,
                    LoginHelper.getAccount());

            lmsFrameUnconformRegister.setVerifyFinish(reason);
            lmsFrameUnconformRegister.setOrgManagerAudit2(autit);
            lmsFrameUnconformRegister.setOrgManagerTime2(new Date());
        } else if ("8".equals(status)) {//部门负责人审批驳回(二审)
            // lmsFrameUnconformRegister.setStatus(8);
            lmsFrameUnconformRegister.setStatus(UnconformRegisterEnum.DEPARTMENT_HEAD_TWO_CHECK_BACK);
            setRecord(UnconformRegisterEnum.DEPARTMENT_HEAD_TWO_CHECK_BACK, lmsFrameUnconformRegister.getStatus(),
                    lmsFrameUnconformRegister, 1, lmsFrameUnconformRegister.getRegisterName(),
                    UnconformRegisterEnum.DEPARTMENT_HEAD_TWO_CHECK_BACK.getDisplay().toString() + reason,
                    LoginHelper.getAccount());

            lmsFrameUnconformRegister.setVerifyFinish(reason);
            lmsFrameUnconformRegister.setOrgManagerAudit2(autit);
            lmsFrameUnconformRegister.setOrgManagerTime2(new Date());
        } else if ("5".equals(status)) {//部门负责人审批通过(二审)
            //lmsFrameUnconformRegister.setStatus(5);

            lmsFrameUnconformRegister.setStatus(UnconformRegisterEnum.QUALITY_HEAD_TWO_CHECK_PASS);
            setRecord(UnconformRegisterEnum.QUALITY_HEAD_TWO_CHECK_PASS, lmsFrameUnconformRegister.getStatus(),
                    lmsFrameUnconformRegister, 0, LoginHelper.getAccount().getUserName(),
                    UnconformRegisterEnum.QUALITY_HEAD_TWO_CHECK_PASS.getDisplay().toString() + reason,
                    LoginHelper.getAccount());

            lmsFrameUnconformRegister.setVerifyCheck(reason);
            lmsFrameUnconformRegister.setQualityManagerAudit2(autit);
            lmsFrameUnconformRegister.setQualityManagerTime2(new Date());
        } else if ("9".equals(status)) {//部门负责人审批驳回(二审)
            //lmsFrameUnconformRegister.setStatus(9);
            lmsFrameUnconformRegister.setStatus(UnconformRegisterEnum.QUALITY_HEAD_TWO_CHECK_BACK);
            setRecord(UnconformRegisterEnum.QUALITY_HEAD_TWO_CHECK_BACK, lmsFrameUnconformRegister.getStatus(),
                    lmsFrameUnconformRegister, 1, lmsFrameUnconformRegister.getRegisterName(),
                    UnconformRegisterEnum.QUALITY_HEAD_TWO_CHECK_BACK.getDisplay().toString() + reason,
                    LoginHelper.getAccount());

            lmsFrameUnconformRegister.setVerifyCheck(reason);
            lmsFrameUnconformRegister.setQualityManagerAudit2(autit);
            lmsFrameUnconformRegister.setQualityManagerTime2(new Date());
        } else {
            return null;
        }

        return baseMapper.updateById(lmsFrameUnconformRegister);
    }


    public void setRecord(UnconformRegisterEnum toStatus, UnconformRegisterEnum fromStatus, LmsFrameUnconformRegister register, Integer type, String liable, String remark, Account account) {
        LmsFrameUnconformRegisterRecord registerRecord = new LmsFrameUnconformRegisterRecord();
        registerRecord.setOrigin(fromStatus.getDisplay());
        registerRecord.setTarget(toStatus.getDisplay());
        registerRecord.setUnconformId(register.getId());
        registerRecord.setType(type);
        registerRecord.setLiable(liable);
        registerRecord.setOperator(account.getUserName());
        registerRecord.setRemark(remark);
        lmsFrameUnconformRegisterRecordService.save(registerRecord);
    }
}
