package com.patzn.lims.frame.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.frame.entity.LmsMonthPlan;
import com.patzn.lims.frame.entity.LmsMonthPlanRecord;
import com.patzn.lims.frame.enums.PlanStatusEnum;
import com.patzn.lims.frame.mapper.LmsMonthPlanRecordMapper;
import com.patzn.lims.frame.service.ILmsMonthPlanRecordService;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 月度不确定度计划操作记录表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-07-25
 */
@Service
public class LmsMonthPlanRecordServiceImpl extends BaseServiceImpl<LmsMonthPlanRecordMapper, LmsMonthPlanRecord> implements ILmsMonthPlanRecordService {


    @Override
    public Page<LmsMonthPlanRecord> page(Page<LmsMonthPlanRecord> page, LmsMonthPlanRecord lmsMonthPlanRecord) {
        QueryWrapper wrapper = Wrappers.query(lmsMonthPlanRecord);
        if (null != lmsMonthPlanRecord.getOrigin()) {
            wrapper.like("origin", lmsMonthPlanRecord.getOrigin());
            lmsMonthPlanRecord.setOrigin(null);
        }

        return page(page, wrapper);
    }


    @Override
    public List<LmsMonthPlanRecord> list(LmsMonthPlanRecord lmsMonthPlanRecord) {
        return list(Wrappers.query(lmsMonthPlanRecord));
    }

    @Override
    public boolean saveMonthPlanRecordByIds(LmsMonthPlan plan, PlanStatusEnum fromStatus, Integer type, Long[] ids, String reason) {
        List<LmsMonthPlanRecord> recordList = new ArrayList<>();
        for (Long id : ids) {
            LmsMonthPlanRecord record = new LmsMonthPlanRecord();
            record.setMainPlanId(id);
            record.setType(type);
            record.setOperator(LoginHelper.getAccount().getUserName());
            record.setOrigin(fromStatus.getDisplay());
            record.setTarget(PlanStatusEnum.valueOf(plan.getStatus()).getDisplay());
            record.setRemark(reason);
            recordList.add(record);
        }
        return recordList.size() > 0 && super.saveBatch(recordList);
    }
}
