package com.patzn.lims.frame.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.cloud.commons.controller.LoginHelper;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.frame.entity.LmsQcMainPlan;
import com.patzn.lims.frame.entity.LmsQcMainPlanRecord;
import com.patzn.lims.frame.enums.PlanStatusEnum;import com.patzn.lims.frame.mapper.LmsQcMainPlanRecordMapper;
import com.patzn.lims.frame.service.ILmsQcMainPlanRecordService;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 质控计划主表操作记录表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-07-20
 */
@Service
public class LmsQcMainPlanRecordServiceImpl extends BaseServiceImpl<LmsQcMainPlanRecordMapper, LmsQcMainPlanRecord> implements ILmsQcMainPlanRecordService {


    @Override
    public Page<LmsQcMainPlanRecord> page(Page<LmsQcMainPlanRecord> page, LmsQcMainPlanRecord lmsQcMainPlanRecord) {
        QueryWrapper wrapper= Wrappers.query(lmsQcMainPlanRecord);
        if (null != lmsQcMainPlanRecord.getOrigin()) {
            wrapper.like("origin", lmsQcMainPlanRecord.getOrigin());
            lmsQcMainPlanRecord.setOrigin(null);
        }

        return page(page, wrapper);
    }


    @Override
    public List<LmsQcMainPlanRecord> list(LmsQcMainPlanRecord lmsQcMainPlanRecord) {
        return list(Wrappers.query(lmsQcMainPlanRecord));
    }

    @Override
    public boolean saveQcMainPlanRecordByIds(LmsQcMainPlan plan, PlanStatusEnum fromStatus, Integer type, Long[] ids, String reason) {
        List<LmsQcMainPlanRecord> recordList = new ArrayList<>();
        for (Long id : ids) {
            LmsQcMainPlanRecord record = new LmsQcMainPlanRecord();
            record.setMainPlanId(id);
            record.setType(type);
            record.setOperator(LoginHelper.getAccount().getUserName());
            record.setOrigin(fromStatus.getDisplay());
            record.setTarget(PlanStatusEnum.valueOf(plan.getStatus()).getDisplay());
            record.setRemark(reason);
            recordList.add(record);
        }
        return recordList.size() > 0 && super.saveBatch(recordList);
    }
}
