package com.patzn.lims.frame.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.frame.entity.LmsQcSubPlan;
import com.patzn.lims.frame.entity.LmsQcSubPlanRecord;
import com.patzn.lims.frame.enums.PlanStatusEnum;import com.patzn.lims.frame.mapper.LmsQcSubPlanRecordMapper;
import com.patzn.lims.frame.service.ILmsQcSubPlanRecordService;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 质控计划子表操作记录表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-07-20
 */
@Service
public class LmsQcSubPlanRecordServiceImpl extends BaseServiceImpl<LmsQcSubPlanRecordMapper, LmsQcSubPlanRecord> implements ILmsQcSubPlanRecordService {


    @Override
    public Page<LmsQcSubPlanRecord> page(Page<LmsQcSubPlanRecord> page, LmsQcSubPlanRecord lmsQcSubPlanRecord) {
        QueryWrapper wrapper = Wrappers.query(lmsQcSubPlanRecord);
        if (null != lmsQcSubPlanRecord.getOrigin()) {
            wrapper.like("origin", lmsQcSubPlanRecord.getOrigin());
            lmsQcSubPlanRecord.setOrigin(null);
        }

        return page(page, wrapper);
    }


    @Override
    public List<LmsQcSubPlanRecord> list(LmsQcSubPlanRecord lmsQcSubPlanRecord) {
        return list(Wrappers.query(lmsQcSubPlanRecord));
    }

    @Override
    public boolean saveQcSubPlanRecordByIds(LmsQcSubPlan plan, PlanStatusEnum fromStatus, Integer type, Long[] ids, String reason) {
        List<LmsQcSubPlanRecord> recordList = new ArrayList<>();
        for (Long id : ids) {
            LmsQcSubPlanRecord record = new LmsQcSubPlanRecord();
            record.setSubPlanId(id);
            record.setType(type);
            record.setOperator(LoginHelper.getAccount().getUserName());
            record.setOrigin(fromStatus.getDisplay());
            record.setTarget(PlanStatusEnum.valueOf(plan.getStatus()).getDisplay());
            record.setRemark(reason);
            recordList.add(record);
        }
        return recordList.size() > 0 && super.saveBatch(recordList);
    }
}
