package com.patzn.lims.frame.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.frame.entity.LmsQcSubPlan;
import com.patzn.lims.frame.enums.PlanStatusEnum;import com.patzn.lims.frame.mapper.LmsQcSubPlanMapper;
import com.patzn.lims.frame.service.ILmsQcSubPlanAttachmentService;
import com.patzn.lims.frame.service.ILmsQcSubPlanRecordService;
import com.patzn.lims.frame.service.ILmsQcSubPlanService;
import com.patzn.lims.res.service.ILmsPropertyService;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 内部质控计划子表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-07-09
 */
@Service
public class LmsQcSubPlanServiceImpl extends BaseServiceImpl<LmsQcSubPlanMapper, LmsQcSubPlan> implements ILmsQcSubPlanService {

    @Autowired
    private ILmsQcSubPlanAttachmentService lmsQcSubPlanAttachmentService;
    @Autowired
    private ILmsPropertyService lmsPropertyService;
    @Autowired
    private ILmsQcSubPlanRecordService lmsQcSubPlanRecordService;


    @Override
    public Page<LmsQcSubPlan> page(Page<LmsQcSubPlan> page, LmsQcSubPlan lmsQcSubPlan) {
        QueryWrapper wrapper = Wrappers.query(lmsQcSubPlan);
        return page(page, wrapper);
    }


    @Override
    public List<LmsQcSubPlan> list(LmsQcSubPlan lmsQcSubPlan) {
        return list(Wrappers.query(lmsQcSubPlan));
    }

    @Override
    public Page<LmsQcSubPlan> pageSubPlan(Page<LmsQcSubPlan> page, LmsQcSubPlan lmsQcSubPlan, Date startDate, Date endDate) {
        PtAssert.fail(null == lmsQcSubPlan || null == lmsQcSubPlan.getMainPlanId(), "请确认主计划");
        return page.setRecords(baseMapper.selectSubPlan(page, lmsQcSubPlan, startDate, endDate));
    }

    @Override
    public boolean copy(LmsQcSubPlan lmsQcSubPlan, Account account) {
        PtAssert.fail(null == lmsQcSubPlan || null == lmsQcSubPlan.getMainPlanId(), "请确认主计划");
        lmsQcSubPlan.setId(IdWorker.getId());
        lmsQcSubPlan.setStatus((Integer) PlanStatusEnum.DRAFT.getValue());
        lmsQcSubPlan.setProgress((Integer) PlanStatusEnum.DRAFT.getValue());
        lmsQcSubPlan.setUname(account.getUserName());
        return super.save(lmsQcSubPlan);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean submit(Long[] ids, String result, Date endDate) {
        PtAssert.fail(ArrayUtils.isEmpty(ids), "请选择要提交的计划");
        PtAssert.fail(null == result || "".equals(result), "请输入监控结果");
        PtAssert.fail(null == endDate, "请输入完成日期");
        List<LmsQcSubPlan> list = super.list(Wrappers.<LmsQcSubPlan>query().in("id", ids));
        for (LmsQcSubPlan plan : list) {
            PtAssert.fail(0 == lmsQcSubPlanAttachmentService.getCountByPlanId(plan.getId()), "请上传附件后再提交计划");
        }
        return super.update(new LmsQcSubPlan().setStatus((Integer)PlanStatusEnum.END.getValue()).setProgress((Integer)PlanStatusEnum.END.getValue()).setEndDate(endDate).setMonitorResult(result),
                Wrappers.<LmsQcSubPlan>query().in("id", ids))
                && lmsQcSubPlanRecordService.saveQcSubPlanRecordByIds(new LmsQcSubPlan().setStatus((Integer)PlanStatusEnum.END.getValue()), PlanStatusEnum.DRAFT, 0, ids, "计划提交");
    }

    @Override
    public boolean removeByIds(Long[] ids) {
        PtAssert.fail(ArrayUtils.isEmpty(ids), "请选择要删除的计划");
        int num = super.count(Wrappers.<LmsQcSubPlan>query().in("id", ids).eq("status", PlanStatusEnum.DRAFT));
        PtAssert.fail(num != ids.length, "只能删除草稿计划");
        return super.remove(Wrappers.<LmsQcSubPlan>query().in("id", ids));
    }

    @Override
    public boolean updatePlanById(LmsQcSubPlan lmsQcSubPlan) {
        PtAssert.fail(null == lmsQcSubPlan.getId(), "id不能为空");
        LmsQcSubPlan dbSubPlan = super.getById(lmsQcSubPlan.getId());
        String remark = lmsPropertyService.getCompareDifferent(lmsQcSubPlan, dbSubPlan, "质控子计划对比", "质控子计划修改内容：");
        if (StringUtils.isNotEmpty(remark)) {
            lmsQcSubPlanRecordService.saveQcSubPlanRecordByIds(dbSubPlan, PlanStatusEnum.valueOf(dbSubPlan.getStatus()), 2, new Long[]{dbSubPlan.getId()}, remark);
        }
        return super.updateById(lmsQcSubPlan);
    }

}
