package com.patzn.lims.frame.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.oss.OssClient;
import com.patzn.lims.core.oss.OssFileResult;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.frame.entity.LmsYearPlanFile;
import com.patzn.lims.frame.mapper.LmsYearPlanFileMapper;
import com.patzn.lims.frame.service.ILmsYearPlanFileService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

import static java.util.stream.Collectors.toList;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-07-25
 */
@Service
public class LmsYearPlanFileServiceImpl extends BaseServiceImpl<LmsYearPlanFileMapper, LmsYearPlanFile> implements ILmsYearPlanFileService {

    @Autowired
    private OssClient ossClient;

    @Override
    public Page<LmsYearPlanFile> page(Page<LmsYearPlanFile> page, LmsYearPlanFile lmsYearPlanFile) {
        QueryWrapper wrapper = Wrappers.query(lmsYearPlanFile);

        return page(page, wrapper);
    }


    @Override
    public List<LmsYearPlanFile> list(LmsYearPlanFile lmsYearPlanFile) {
        return list(Wrappers.query(lmsYearPlanFile));
    }

    @Override
    public LmsYearPlanFile saveAndUpload(MultipartFile file, String bucketName, String foldPath, Long relId, Integer type) {
        OssFileResult result = ossClient.upload(file);
        if (null == result) {
            return null;
        }
        LmsYearPlanFile lmsYearPlanFile = new LmsYearPlanFile();
        String fileName = file.getOriginalFilename();
        lmsYearPlanFile.setRelId(relId);
        lmsYearPlanFile.setOrginName(fileName);
        lmsYearPlanFile.setFilePath(result.getObjectKey());
        //核查类型
        lmsYearPlanFile.setType(type);
        save(lmsYearPlanFile);
        lmsYearPlanFile.setFilePath(ossClient.getUrl(lmsYearPlanFile.getFilePath()).toString());
        return lmsYearPlanFile;
    }


    @Override
    public boolean deleteBatch(Long[] ids) {
        List<LmsYearPlanFile> yearPlanFileList = list(Wrappers.<LmsYearPlanFile>query().in("id", ids));
        if (CollectionUtils.isEmpty(yearPlanFileList)) {
            return false;
        }
        ossClient.deleteObjects(yearPlanFileList.stream().map(e -> e.getFilePath()).collect(toList()));
        return remove(Wrappers.<LmsYearPlanFile>query().in("id", ids));
    }


    @Override
    public boolean deleteByYearPlan(Long yearPlanId) {
        if (null == yearPlanId) {
            return false;
        }
        return remove(Wrappers.<LmsYearPlanFile>query().eq("rel_id", yearPlanId));
    }

    @Override
    public void downloadFile(Long id, HttpServletResponse response) {
        LmsYearPlanFile attachment = super.getById(id);
        if (null == attachment) {
            PtAssert.fail("抱歉！该附件不存在");
        }
        ossClient.download(attachment.getFilePath(), attachment.getOrginName(), response);
    }
}
