package com.patzn.lims.frame.service.impl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.web.BaseServiceImpl;

import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.frame.entity.LmsYearPlan;
import com.patzn.lims.frame.entity.LmsYearPlanRecord;
import com.patzn.lims.frame.enums.PlanStatusEnum;
import com.patzn.lims.frame.mapper.LmsYearPlanRecordMapper;
import com.patzn.lims.frame.service.ILmsYearPlanRecordService;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 年度不确定度计划主表操作记录表 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2018-07-25
 */
@Service
public class LmsYearPlanRecordServiceImpl extends BaseServiceImpl<LmsYearPlanRecordMapper, LmsYearPlanRecord> implements ILmsYearPlanRecordService {


    @Override
    public Page<LmsYearPlanRecord> page(Page<LmsYearPlanRecord> page, LmsYearPlanRecord lmsYearPlanRecord) {

        QueryWrapper wrapper = Wrappers.query(lmsYearPlanRecord);
        if (null != lmsYearPlanRecord.getOrigin()) {
            wrapper.like("origin", lmsYearPlanRecord.getOrigin());
            lmsYearPlanRecord.setOrigin(null);
        }

        return page(page, wrapper);
    }


    @Override
    public List<LmsYearPlanRecord> list(LmsYearPlanRecord lmsYearPlanRecord) {
        return list(Wrappers.query(lmsYearPlanRecord));
    }


    @Override
    public boolean saveYearPlanRecordByIds(LmsYearPlan plan, PlanStatusEnum fromStatus, Integer type, Long[] ids, String reason) {
        List<LmsYearPlanRecord> recordList = new ArrayList<>();
        for (Long id : ids) {
            LmsYearPlanRecord record = new LmsYearPlanRecord();
            record.setMainPlanId(id);
            record.setType(type);
            record.setOperator(LoginHelper.getAccount().getUserName());
            record.setOrigin(fromStatus.getDisplay());
            record.setTarget(PlanStatusEnum.valueOf(plan.getStatus()).getDisplay());
            record.setRemark(reason);
            recordList.add(record);
        }
        return recordList.size() > 0 && super.saveBatch(recordList);
    }
}
