package com.patzn.lims.online.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.online.dto.TableDataDTO;
import com.patzn.lims.online.entity.PtOnlFormHead;
import com.patzn.lims.online.service.IPtOnlFormHeadService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 表单表 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-05-07
 */
@Api(tags = "表单表")
@RestController
@RequestMapping("/v1/onl_form_head")
public class PtOnlFormHeadController extends ServiceController<IPtOnlFormHeadService, PtOnlFormHead> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<PtOnlFormHead>> getPage(PtOnlFormHead ptOnlFormHead) {
        return success(baseService.page(getPage(), ptOnlFormHead));
	}




    @ApiOperation(value = "添加在线表单", notes = "添加在线表单")
    @PostMapping("/add-online-table")
    public PtResult<Boolean> addOnlineTable(@RequestBody TableDataDTO dto) {
        return success(baseService.addOnlineTable(dto,getAccount()));
    }



    @ApiOperation(value = "同步数据库", notes = "同步数据库")
    @PostMapping("synch-table")
    public PtResult<Boolean> synchTable(@RequestParam("id") Long id) {
        return success(baseService.synchTable(id,getAccount()));
    }

}
