package com.patzn.lims.online.entity;

import java.util.Date;
import com.patzn.lims.core.bean.BaseEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 字段表
 * </p>
 *
 * @author wwd
 * @since 2020-05-13
 */
@Data
@Accessors(chain = true)
@ApiModel
public class PtOnlFormField extends BaseEntity {

    @ApiModelProperty(value = "表ID")
	private Long formHeadId;
    @ApiModelProperty(value = "字段名字")
	private String dbFieldName;
    @ApiModelProperty(value = "字段备注")
	private String dbFieldTxt;
    @ApiModelProperty(value = "原字段名")
	private String dbFieldNameOld;
    @ApiModelProperty(value = "是否主键0否1是")
	private Integer dbIsKey;
    @ApiModelProperty(value = "是否允许为空0否 1是")
	private Integer dbIsNull;
    @ApiModelProperty(value = "数据库字段类型")
	private String dbType;
    @ApiModelProperty(value = "数据库字段长度")
	private Integer dbLength;
    @ApiModelProperty(value = "小数点")
	private Integer dbPointLength;
    @ApiModelProperty(value = "表字段默认值")
	private String dbDefaultVal;
    @ApiModelProperty(value = "字典code")
	private String dictField;
    @ApiModelProperty(value = "字典表")
	private String dictTable;
    @ApiModelProperty(value = "字典TXT")
	private String dictText;
    @ApiModelProperty(value = "表单控件类型")
	private String fieldShowType;
    @ApiModelProperty(value = "跳转url")
	private String fieldHref;
    @ApiModelProperty(value = "表单控件长度")
	private Integer fieldLength;
    @ApiModelProperty(value = "表单字段校验规则")
	private String fieldValidType;
    @ApiModelProperty(value = "字段是否必填")
	private String fieldMustInput;
    @ApiModelProperty(value = "扩展参数JSON")
	private String fieldExtendJson;
    @ApiModelProperty(value = "填值规则code")
	private String fieldValueRuleCode;
    @ApiModelProperty(value = "是否查询条件0否1是")
	private Integer isQuery;
    @ApiModelProperty(value = "表单是否显示")
	private Integer isShowForm;
    @ApiModelProperty(value = "列表是否显示")
	private Integer isShowList;
    @ApiModelProperty(value = "是否只读")
	private Integer isReadOnly;
    @ApiModelProperty(value = "查询模式")
	private String queryMode;
    @ApiModelProperty(value = "外键主表名")
	private String mainTable;
    @ApiModelProperty(value = "外键主键字段")
	private String mainField;
    @ApiModelProperty(value = "排序")
	private Integer orderNum;
    @ApiModelProperty(value = "修改人")
	private Long updateBy;
	private Date updateTime;
    @ApiModelProperty(value = "创建时间")
	private Date createTime;
    @ApiModelProperty(value = "创建人")
	private Long createBy;


}
