package com.patzn.lims.online.entity;

import java.util.Date;
import com.patzn.lims.core.bean.BaseEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 表单表
 * </p>
 *
 * @author wwd
 * @since 2020-05-07
 */
@Data
@Accessors(chain = true)
@ApiModel
public class PtOnlFormHead extends BaseEntity {

    @ApiModelProperty(value = "表名")
	private String tableName;
    @ApiModelProperty(value = "表类型：0单表、1主表、2.附表")
	private Integer tableType;
    @ApiModelProperty(value = "表版本")
	private Integer tableVersion;
    @ApiModelProperty(value = "表说明")
	private String tableTxt;
    @ApiModelProperty(value = "是否带checkbox")
	private String isCheckbox;
    @ApiModelProperty(value = "同步数据库状态")
	private String isDbSynch;
    @ApiModelProperty(value = "是否分页")
	private String isPage;
    @ApiModelProperty(value = "是否是树")
	private String isTree;
    @ApiModelProperty(value = "主键生成序列")
	private String idSequence;
    @ApiModelProperty(value = "主键类型")
	private String idType;
    @ApiModelProperty(value = "查询模式")
	private String queryMode;
    @ApiModelProperty(value = "映射关系0一对多 1一对一")
	private Integer relationType;
    @ApiModelProperty(value = "子表")
	private String subTableStr;
    @ApiModelProperty(value = "附表排序序号")
	private Integer tabOrderNum;
    @ApiModelProperty(value = "树形表单父ID")
	private String treeParentIdField;
    @ApiModelProperty(value = "树表主键字段")
	private String treeIdField;
    @ApiModelProperty(value = "树开表单列字段")
	private String treeFieldname;
    @ApiModelProperty(value = "表单分类")
	private String formCategory;
    @ApiModelProperty(value = "PC表单模板")
	private String formTemplate;
    @ApiModelProperty(value = "表单")
	private String formTemplateMobile;
    @ApiModelProperty(value = "是否有横向滚动条")
	private Integer scroll;
    @ApiModelProperty(value = "复制版本号")
	private Integer copyVersion;
    @ApiModelProperty(value = "复制表类型1为复制表 0为原始表")
	private Integer copyType;
    @ApiModelProperty(value = "原始表ID")
	private Long physicId;
    @ApiModelProperty(value = "更新人")
	private Long updateBy;
    @ApiModelProperty(value = "更新时间")
	private Date updateTime;
    @ApiModelProperty(value = "创建人")
	private Long createBy;
    @ApiModelProperty(value = "创建时间")
	private Date createTime;
    @ApiModelProperty(value = "主题模板")
	private String themeTemplate;


}
