package com.patzn.lims.res.common;

import org.apache.commons.lang3.StringUtils;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 对象比较 工具类
 * <p>
 *
 * @author xutao
 * @date 2019/9/28
 */
public class ClassComparedUtil {

    /**
     * 比较两个实体属性值，返回一个map以有差异的属性名为key，value为一个Map分别存oldObject,newObject此属性名的值
     *
     * @param oldObject 进行属性比较的对象1
     * @param newObject 进行属性比较的对象2
     * @param compares  需要比对的字段
     * @param map       中英文对照
     * @return 属性差异比较结果
     */
    public static String compareObjects(Object oldObject, Object newObject, List<String> compares, Map<String, String> map) {
        String message = "";
        try {
            /**
             * 只有两个对象都是同一类型的才有可比性
             */
            if (oldObject.getClass() == newObject.getClass()) {
                Class clazz = oldObject.getClass();
                //获取object的所有属性
                PropertyDescriptor[] pds = Introspector.getBeanInfo(clazz, Object.class).getPropertyDescriptors();
                for (PropertyDescriptor pd : pds) {
                    //遍历获取属性名
                    String name = pd.getName();
                    if (compares.contains(name)) {
                        //只比较需要比对的字段的字段
                        //获取属性的get方法
                        Method readMethod = pd.getReadMethod();
                        // 在oldObject上调用get方法等同于获得oldObject的属性值
                        Object oldValue = readMethod.invoke(oldObject);
                        // 在newObject上调用get方法等同于获得newObject的属性值
                        Object newValue = readMethod.invoke(newObject);
                        if (oldValue instanceof List) {
                            continue;
                        }
                        if (newValue instanceof List) {
                            continue;
                        }
                        if (oldValue instanceof Timestamp) {
                            oldValue = new Date(((Timestamp) oldValue).getTime());
                        }
                        if (newValue instanceof Timestamp) {
                            newValue = new Date(((Timestamp) newValue).getTime());
                        }
                        if (oldValue == null && newValue == null) {
                            continue;
                        }
                        if (!oldValue.equals(newValue)) {
                            // 比较这两个值是否相等,不等就可以放入map了
                            message += map.get(name) + "：" + oldValue + "，修改为：" + newValue + "/";
                        }
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (StringUtils.isNotBlank(message)) {
            return message.substring(0, message.length() - 1);
        } else {
            return message;
        }

    }


}
