package com.patzn.lims.res.common;

import com.baomidou.kisso.common.util.EnvUtil;

import java.io.File;

/**
 * <p>
 * LICENSE 相关文件存放路径工具类
 * </p>
 *
 * @author hubin
 * @since 2018-04-13
 */
public class PathUtils {

    private static String STORE_FILE = null;


    /**
     * 获取默认存储路径
     */
    public static String getStorePath() {
        if (null != STORE_FILE) {
            return STORE_FILE;
        }
        STORE_FILE = "/patzn";
        if (!EnvUtil.isLinux()) {
            STORE_FILE = "C:" + STORE_FILE;
        }
        return STORE_FILE;
    }


    /**
     * <p>
     * 获取绝对路径
     * </p>
     *
     * @param fileName 文件名
     * @return
     */
    public static String getAbsolutePath(String fileName) {
        StringBuffer out = new StringBuffer(getStorePath());
        out.append(File.separator).append(fileName);
        return out.toString();
    }


    /**
     * <p>
     * 获取存储文件
     * </p>
     *
     * @param fileName 文件名
     * @return
     */
    public static File getStoreFile(String fileName) {
        return new File(getAbsolutePath(fileName));
    }
}
