package com.patzn.lims.res.controller;

import com.patzn.lims.common.EnumObjectVO;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.SuperController;
import com.patzn.lims.res.service.IEnumService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>
 * Enum 相关控制器
 * </p>
 *
 * @author hubin
 * @since 2018-04-08
 */
@Api(description = "Enum 相关操作")
@RestController
@RequestMapping("/v1/enum")
public class EnumController extends SuperController {

    @Autowired
    private IEnumService enumService;


    @ApiOperation(value = "根据枚举名称获取枚举属性信息", notes = "根据枚举名称获取枚举属性信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "name", value = "枚举名称", required = true, paramType = "path", dataType = "String"),
    })
    @GetMapping("/{name}")
    public PtResult<List<EnumObjectVO>> enumInfo(@PathVariable("name") String name) {
        return success(enumService.getEnumList(name));
    }

}
