package com.patzn.lims.res.controller;

import com.baomidou.kisso.annotation.Action;
import com.baomidou.kisso.annotation.Login;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.res.entity.LmsBaseDict;
import com.patzn.lims.res.service.ILmsBaseDictService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * <p>
 * 字典表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2017-08-28
 */
@Api(description = "字典表")
@RestController
@RequestMapping("/v1/dict")
public class LmsBaseDictController extends ServiceController<ILmsBaseDictService,LmsBaseDict> {




    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
    })
    @PostMapping("/page")
    public PtResult<Page<LmsBaseDict>> getPage(LmsBaseDict lmsBaseDict) {
        return success(baseService.page(getPage(), lmsBaseDict));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    public PtResult<LmsBaseDict> get(@PathVariable("id") Long id) {
        return success(baseService.getById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsBaseDict lmsBaseDict) {
        return success(baseService.updateById(lmsBaseDict));
    }

    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    public PtResult<Boolean> add(LmsBaseDict lmsBaseDict) {
        return success(baseService.save(lmsBaseDict));
    }


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @DeleteMapping("/")
    public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(baseService.remove(Wrappers.query(new LmsBaseDict()).in("id", ids)));
    }


    @ApiOperation(value = "查询分类树", notes = "查询分类数据列表")
    @PostMapping("/dict_tree_all")
    public PtResult<List<LmsBaseDict>> getDictAllTree(String name) {
        return success(baseService.getDictAllTree(name));
    }

    @ApiOperation(value = "根据名称分类查询字典", notes = "查询分类数据列表")
    @PostMapping("/dict_by_name_type")
    public PtResult<LmsBaseDict> getDictByNameType(LmsBaseDict dict) {
        return success(baseService.getDictByNameType(dict));
    }

    @ApiOperation(value = "根据名称分类查询字典", notes = "查询分类数据列表")
    @PostMapping("/dict_query")
    public PtResult<List<LmsBaseDict>> getDictQuery(LmsBaseDict dict) {
        return success(baseService.getDictQuery(dict));
    }


    @ApiOperation(value = "查询分类树", notes = "查询分类数据列表")
    @GetMapping("/dict_class_item")
    @Login(action = Action.Skip)
    public PtResult<List<LmsBaseDict>> getDictAllByClass(String classType, String name) {
        return success(baseService.getDictAllByClass(classType, name));
    }

    @ApiOperation(value = "查询多个字典", notes = "查询多个字典")
    @PostMapping("/list_dict")
    @Login(action = Action.Skip)
    public PtResult<List<List<LmsBaseDict>>> listDict(String[] classTypeList) {
        return success(baseService.listDict(classTypeList));
    }


    @ApiOperation(value = "查询不重复的分类树", notes = "查询分类数据列表")
    @GetMapping("/dict_type_no_repeat")
    public PtResult<List<LmsBaseDict>> getDictTypeNoRepeat() {
        return success(baseService.getDictTypeNoRepeat());
    }

    @ApiOperation(value = "根据名称分类查询字典", notes = "查询分类数据列表")
    @PostMapping("/dict_by_name_type_food")
    public PtResult<LmsBaseDict> getDictByNameTypeFood(@RequestBody LmsBaseDict dict) {
        return success(baseService.getDictByNameType(dict));
    }


    @ApiOperation(value = "导入分样组件 EXCEL", notes = "导入企业样品 EXCEL 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "contractId", value = "合同 ID", required = true, paramType = "path", dataType = "long"),
    })
    @PostMapping("/base_dict_import/")
    public PtResult<Boolean> baseDictImport(MultipartFile file) {
        return success(baseService.baseDictImport(file));
    }


    @ApiOperation(value = "导入分样组件 EXCEL", notes = "导入企业样品 EXCEL 的数据内容")
    @PostMapping("/export/")
    public void export() {
        baseService.export(response, currentCompanyId());
    }

}
