package com.patzn.lims.res.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.res.entity.LmsCarInfo;
import com.patzn.lims.res.service.ILmsCarInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 车辆信息表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-03-26
 */
@Api(description = "车辆信息表")
@RestController
@RequestMapping("/v1/car_info")
public class LmsCarInfoController extends ServiceController<ILmsCarInfoService, LmsCarInfo> {

    @Autowired
    private ILmsCarInfoService lmsCarInfoService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
    })
    @PostMapping("/page")
    public PtResult<IPage<LmsCarInfo>> getPage(LmsCarInfo lmsCarInfo) {
        lmsCarInfo.setStatus(0);
        return success(lmsCarInfoService.page(getPage(), lmsCarInfo));
    }


    @ApiOperation(value = "车辆分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_car_manage")
    public PtResult<IPage<LmsCarInfo>> getPageCarManage(LmsCarInfo lmsCarInfo) {
        return success(lmsCarInfoService.page(getPage(), lmsCarInfo));
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsCarInfo>> getList(LmsCarInfo lmsCarInfo) {
        return success(lmsCarInfoService.list(lmsCarInfo));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    public PtResult<LmsCarInfo> get(@PathVariable("id") Long id) {
        return success(lmsCarInfoService.getById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsCarInfo lmsCarInfo) {
        return success(lmsCarInfoService.updateCarById(lmsCarInfo));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    public PtResult<Boolean> add(LmsCarInfo lmsCarInfo) {
        return success(lmsCarInfoService.saveCar(lmsCarInfo));
    }


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @DeleteMapping("/")
    public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsCarInfoService.remove(Wrappers.query(new LmsCarInfo()).in("id", ids)));
    }


    @ApiOperation(value = "车辆设置停启用", notes = "设置停启用")
    @PostMapping("/stop_start/{id}")
    public PtResult<Boolean> setStopStart(@PathVariable("id") Long id, @RequestParam("status") Integer status) {
        return success(lmsCarInfoService.setStopStart(id,status));
    }



}
