package com.patzn.lims.res.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.SuperController;
import com.patzn.lims.res.entity.LmsCarRecord;
import com.patzn.lims.res.service.ILmsCarRecordService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 车辆使用记录表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-03-26
 */
@Api(description = "车辆使用记录表")
@RestController
@RequestMapping("/v1/car_record")
public class LmsCarRecordController extends SuperController {

    @Autowired
    private ILmsCarRecordService lmsCarRecordService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<Page<LmsCarRecord>> getPage(LmsCarRecord lmsCarRecord) {
        return success(lmsCarRecordService.page(getPage(), lmsCarRecord));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    public PtResult<LmsCarRecord> get(@PathVariable("id") Long id) {
        return success(lmsCarRecordService.getById(id));
    }
}
