package com.patzn.lims.res.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.SuperController;
import com.patzn.lims.res.entity.LmsClassifyRelGruop;
import com.patzn.lims.res.vo.LmsClassifyRelGruopVO;
import com.patzn.lims.res.service.ILmsClassifyRelGruopService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 模板类别与用户编组管理表 前端控制器
 * </p>
 *
 * @author SunYunGang
 * @since 2019-06-18
 */
@Api(description = "模板类别与用户编组管理表")
@RestController
@RequestMapping("/v1/classify_rel_gruop")
public class LmsClassifyRelGruopController extends SuperController {

    @Autowired
    private ILmsClassifyRelGruopService lmsClassifyRelGruopService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<Page<LmsClassifyRelGruop>> getPage(LmsClassifyRelGruop lmsClassifyRelGruop) {
        return success(lmsClassifyRelGruopService.page(getPage(), lmsClassifyRelGruop));
	}


    @ApiOperation(value = "模板类别与用户编组已绑定分页", notes = "模板类别与用户编组已绑定分页")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_vo")
    public PtResult<Page<LmsClassifyRelGruopVO>> getPageVO(LmsClassifyRelGruopVO lmsClassifyRelGruop) {
        return success(lmsClassifyRelGruopService.getPageVO(getPage(), lmsClassifyRelGruop));
    }

    @ApiOperation(value = "与用户编组绑定", notes = "与用户编组绑定")
    @PostMapping("/binding_user_group")
    public PtResult<Boolean> bindingUserGroup(@RequestParam("userGruopIds") Long[] userGruopIds, @RequestParam("templateClassifyId")Long templateClassifyId){
        return success(lmsClassifyRelGruopService.bindingUserGroup(userGruopIds,templateClassifyId));
    }




    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsClassifyRelGruop>> getList(LmsClassifyRelGruop lmsClassifyRelGruop) {
        return success(lmsClassifyRelGruopService.list(lmsClassifyRelGruop));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    public PtResult<LmsClassifyRelGruop> get(@PathVariable("id") Long id) {
        return success(lmsClassifyRelGruopService.getById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsClassifyRelGruop lmsClassifyRelGruop) {
        lmsClassifyRelGruop.setId(id);
        return success(lmsClassifyRelGruopService.updateById(lmsClassifyRelGruop));
	}
    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    public PtResult<Boolean> add(LmsClassifyRelGruop lmsClassifyRelGruop) {
        return success(lmsClassifyRelGruopService.save(lmsClassifyRelGruop));
    }




    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
	@DeleteMapping("/")
	public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsClassifyRelGruopService.remove(Wrappers.query(new LmsClassifyRelGruop()).in("id", ids)));
	}

}
