package com.patzn.lims.res.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.SuperController;
import com.patzn.lims.res.dto.CodeTypeDTO;
import com.patzn.lims.res.entity.LmsCodeRule;
import com.patzn.lims.res.entity.LmsCodeRuleRecord;
import com.patzn.lims.res.enums.CodeTypeEnum;
import com.patzn.lims.res.service.ILmsCodeRuleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 编号规则 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-04-11
 */
@Api(description = "编号规则")
@RestController
@RequestMapping("/v1/code_rule")
public class LmsCodeRuleController extends SuperController {

    @Autowired
    private ILmsCodeRuleService lmsCodeRuleService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<Page<LmsCodeRule>> getPage(LmsCodeRule lmsCodeRule) {
        return success(lmsCodeRuleService.page(getPage(), lmsCodeRule));
    }

    @PostMapping("/getKey")
    public PtResult<String> getKey(@RequestBody CodeTypeDTO dto) {
        CodeTypeEnum codeTypeEnum = dto.getCodeTypeEnum();
        return success(lmsCodeRuleService.getKey((Integer) codeTypeEnum.getValue(), codeTypeEnum.getDisplay(), dto.getBaseEntity()));
    }






    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    public PtResult<LmsCodeRule> get(@PathVariable("id") Long id) {
        return success(lmsCodeRuleService.getById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsCodeRule lmsCodeRule) {
        lmsCodeRule.setId(id);
        return success(lmsCodeRuleService.updateCodeRule(lmsCodeRule));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    public PtResult<Boolean> add(LmsCodeRule lmsCodeRule) {
        return success(lmsCodeRuleService.save(lmsCodeRule));
    }


    @ApiOperation(value = "编号记录分页列表", notes = "编号记录分页列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_rule_record")
    public PtResult<Page<LmsCodeRuleRecord>> getPageRecord(LmsCodeRuleRecord record) {
        return success(lmsCodeRuleService.pageRecord(getPage(), record));
    }


    @ApiOperation(value = "根据记录 id 修改信息", notes = "根据指定记录 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/record_{id}")
    public PtResult<Boolean> editRecord(@PathVariable("id") Long id, @RequestParam("sn") Integer sn) {
        return success(lmsCodeRuleService.editRecord(id, sn));
    }
}
