package com.patzn.lims.res.controller;

import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.SuperController;
import com.patzn.lims.res.entity.LmsColumnQuestion;
import com.patzn.lims.res.service.ILmsColumnQuestionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 扩展字段问题表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-05-24
 */
@Api(description = "扩展字段问题表")
@RestController
@RequestMapping("/v1/column_question")
public class LmsColumnQuestionController extends SuperController {

    @Autowired
    private ILmsColumnQuestionService lmsColumnQuestionService;


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    public PtResult<LmsColumnQuestion> get(@PathVariable("id") Long id) {
        return success(lmsColumnQuestionService.getById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsColumnQuestion lmsColumnQuestion) {
        lmsColumnQuestion.setId(id);
        return success(lmsColumnQuestionService.updateById(lmsColumnQuestion));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    public PtResult<Boolean> add(LmsColumnQuestion lmsColumnQuestion) {
        return success(lmsColumnQuestionService.save(lmsColumnQuestion));
    }


}
