package com.patzn.lims.res.controller;

import com.baomidou.kisso.annotation.Action;
import com.baomidou.kisso.annotation.Login;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.common.UploadUtils;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.SuperController;
import com.patzn.lims.res.entity.LmsCustomerAttachment;
import com.patzn.lims.res.service.ILmsCustomerAttachmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import java.util.Iterator;
import java.util.List;

/**
 * <p>
 * 客户附件表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-06-21
 */
@Api(description = "客户附件表")
@RestController
@RequestMapping("/v1/customer_attachment")
public class LmsCustomerAttachmentController extends SuperController {

    @Autowired
    private ILmsCustomerAttachmentService lmsCustomerAttachmentService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<Page<LmsCustomerAttachment>> getPage(LmsCustomerAttachment lmsCustomerAttachment) {
        return success(lmsCustomerAttachmentService.page(getPage(), lmsCustomerAttachment));
	}


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsCustomerAttachment>> getList(LmsCustomerAttachment lmsCustomerAttachment) {
        return success(lmsCustomerAttachmentService.list(lmsCustomerAttachment));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    public PtResult<LmsCustomerAttachment> get(@PathVariable("id") Long id) {
        return success(lmsCustomerAttachmentService.getById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsCustomerAttachment lmsCustomerAttachment) {
        lmsCustomerAttachment.setId(id);
        return success(lmsCustomerAttachmentService.updateById(lmsCustomerAttachment));
	}


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
	public PtResult<Boolean> add(LmsCustomerAttachment lmsCustomerAttachment) {
        return success(lmsCustomerAttachmentService.save(lmsCustomerAttachment));
	}


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
	@DeleteMapping("/")
	public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsCustomerAttachmentService.remove( Wrappers.<LmsCustomerAttachment>query().in("id", ids)));
	}



    @ApiOperation(value = "上传客户附件", notes = "上传客户附件")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "customerId", value = "客户 ID", required = true, paramType = "path", dataType = "long"),
    })
    @PostMapping("/{customerId}")
    public PtResult<Boolean> uploadAttachment(@PathVariable("customerId") Long customerId, MultipartHttpServletRequest mhsr) {
        if (UploadUtils.resumeUpload(request)) {
            return null;
        }

        Iterator<String> fns = mhsr.getFileNames();
        while (fns.hasNext()) {
            // 获取上传的文件列表
            return success(lmsCustomerAttachmentService.save(customerId, mhsr.getFile(fns.next())));
        }
        return success(false);
    }


    @ApiOperation(value = "下载客户附件文件", notes = "根据 id 下载客户附件文件")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @Login(action = Action.Skip)
    @GetMapping("/download/{id}")
    public void download(@PathVariable("id") Long id) {
        lmsCustomerAttachmentService.download(id, response);
    }


    @ApiOperation(value = "批量下载文件", notes = "批量下载文件")
    @GetMapping("/downloadBatch")
    @Login(action = Action.Skip)
    public void downloadFiles(@RequestParam("ids") Long[] ids) {
        lmsCustomerAttachmentService.downloadFiles(ids, response);
    }


}
