package com.patzn.lims.res.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.SuperController;
import com.patzn.lims.res.entity.LmsCustomerContact;
import com.patzn.lims.res.service.ILmsCustomerContactService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 客户联系人信息表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-08-08
 */
@Api(description = "客户联系人信息表")
@RestController
@RequestMapping("/v1/customer_contact")
public class LmsCustomerContactController extends SuperController {

    @Autowired
    private ILmsCustomerContactService lmsCustomerContactService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<Page<LmsCustomerContact>> getPage(LmsCustomerContact lmsCustomerContact) {
        return success(lmsCustomerContactService.page(getPage(), lmsCustomerContact));
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsCustomerContact>> getList(LmsCustomerContact lmsCustomerContact) {
        return success(lmsCustomerContactService.list(lmsCustomerContact));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    public PtResult<LmsCustomerContact> get(@PathVariable("id") Long id) {
        return success(lmsCustomerContactService.getById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsCustomerContact lmsCustomerContact) {
        lmsCustomerContact.setId(id);
        return success(lmsCustomerContactService.updateById(lmsCustomerContact));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    public PtResult<Boolean> add(@RequestBody LmsCustomerContact lmsCustomerContact) {
        PtAssert.fail(null == lmsCustomerContact || null == lmsCustomerContact.getCustomerId(), "请确认客户");
        return success(lmsCustomerContactService.save(lmsCustomerContact));
    }


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @DeleteMapping("/")
    public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsCustomerContactService.remove( Wrappers.<LmsCustomerContact>query().in("id", ids)));
    }

    @PostMapping("/list_by_customer")
    public PtResult<List<LmsCustomerContact>> listAllByCus(@RequestParam("customerId") Long customerId) {
        return success(lmsCustomerContactService.listAllByCus(customerId));
    }


    @ApiOperation(value = "根据客户获取联系人下拉列表", notes = "根据客户获取联系人下拉列表")
    @GetMapping("/list_customer_contact")
    public PtResult<List<LmsCustomerContact>> getListCustomerContact(LmsCustomerContact lmsCustomerContact) {
        return success(lmsCustomerContactService.getListCustomerContact(lmsCustomerContact));
    }


}
