package com.patzn.lims.res.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.SuperController;
import com.patzn.lims.res.entity.LmsCustomer;
import com.patzn.lims.res.entity.LmsCustomerDetail;
import com.patzn.lims.res.vo.LmsCustomerBriefVO;
import com.patzn.lims.res.vo.LmsCustomerDetailVO;
import com.patzn.lims.res.vo.LmsCustomerVO;
import com.patzn.lims.res.service.ILmsCustomerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * <p>
 * 客户信息表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2017-08-28
 */
@Api(description = "客户信息表")
@RestController
@RequestMapping("/v1/customer")
public class LmsCustomerController extends SuperController {

    @Autowired
    private ILmsCustomerService lmsCustomerService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<Page<LmsCustomerDetailVO>> getPage(LmsCustomerDetailVO vo) {
        return success(lmsCustomerService.page(getPage(), vo));
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @GetMapping("/list")
    public PtResult<List<LmsCustomerDetailVO>> getList(LmsCustomerDetailVO vo) {
        return success(lmsCustomerService.list(vo));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    public PtResult<LmsCustomerVO> get(@PathVariable("id") Long id) {
        return success(lmsCustomerService.getVoById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsCustomer lmsCustomer, LmsCustomerDetail lmsCustomerDetail) {
        lmsCustomer.setId(id);
        return success(lmsCustomerService.updateById(lmsCustomer, lmsCustomerDetail));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    public PtResult<Boolean> add(LmsCustomer lmsCustomer, LmsCustomerDetail lmsCustomerDetail) {
        return success(lmsCustomerService.save(lmsCustomer, lmsCustomerDetail));
    }

    @ApiOperation(value = "添加或更新", notes = "添加或更新一条数据")
    @PostMapping("/save_or_update_customer")
    public PtResult<Boolean> addOrUpdate(LmsCustomer lmsCustomer) {
        return success(lmsCustomerService.saveOrUpdate(lmsCustomer));
    }

    @ApiOperation(value = "查询经纬度、省市县", notes = "查询经纬度、省市县")
    @PostMapping("/list_new")
    public PtResult<List<LmsCustomerBriefVO>> listNew(String cname) {
        return success(lmsCustomerService.listNew(cname));
    }


    @ApiOperation(value = "根据 id 删除", notes = "根据 id 删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @DeleteMapping("/{id}")
    public PtResult<Boolean> delete(@PathVariable("id") Long id) {
        return success(lmsCustomerService.removeById(id));
    }


    @ApiOperation(value = "导入客户信息", notes = "导入客户信息")
    @PostMapping("/env_customer_import")
    public PtResult<Boolean> importItem(MultipartFile file) {
        return success(lmsCustomerService.importItem(file));
    }




    @PostMapping("/save")
    public boolean save(@RequestBody LmsCustomer lmsCustomer) {
        return lmsCustomerService.save(lmsCustomer);
    }

    @PostMapping("/list_all")
    public List<LmsCustomer> listAll() {
        return lmsCustomerService.listAll();
    }

    @PostMapping("/one_by_name")
    public PtResult<LmsCustomer> getOneByName(@RequestParam("name") String name) {
        return success(lmsCustomerService.getOneByName(name));
    }
}
