package com.patzn.lims.res.controller;

import com.patzn.lims.core.web.SuperController;
import com.patzn.lims.res.entity.LmsCustomerDetail;
import com.patzn.lims.res.service.ILmsCustomerDetailService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * ${table.comment} 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-08-07
 */
@Api(description = "${table.comment}")
@RestController
@RequestMapping("/v1/customer_detail")
public class LmsCustomerDetailController extends SuperController {

    @Autowired
    private ILmsCustomerDetailService lmsCustomerDetailService;

    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    public boolean add(@RequestBody LmsCustomerDetail lmsCustomerDetail) {
        return lmsCustomerDetailService.save(lmsCustomerDetail);
    }

}
