package com.patzn.lims.res.controller;

import com.patzn.cloud.commons.api.RestResult;
import com.patzn.cloud.commons.controller.ServiceController;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.SuperController;
import com.patzn.lims.res.dto.LmsFormDto;
import com.patzn.lims.res.entity.LmsForm;
import com.patzn.lims.res.service.ILmsFormService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 自定义表单表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-06-04
 */
@Api(description = "自定义表单表")
@RestController
@RequestMapping("/v1/lms_form")
public class LmsFormController extends SuperController {
    @Autowired
    private ILmsFormService lmsFormService;

    @ApiOperation(value = "保存", notes = "保存自定义表单")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "title", value = "标题", required = true, paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = "json", value = "JSON", required = true, paramType = "query", dataType = "String"),
    })
    @PostMapping("/")
    public PtResult<Long> save(@RequestParam String title, @RequestParam String json) {
        return success(lmsFormService.save(title, json));
    }

    @ApiOperation(value = "根据ID更新", notes = "根据ID更新自定义表单")
    @PutMapping("/")
    public PtResult<Boolean> updateById(@Validated LmsFormDto dto) {
        return success(lmsFormService.updateById(dto));
    }

    @ApiOperation(value = "根据ID删除", notes = "根据ID删除自定义表单")
    @DeleteMapping("/{id}")
    public PtResult<Boolean> removeById(@PathVariable("id") Long id) {
        return success(lmsFormService.removeById(id));
    }

    @ApiOperation(value = "根据标题查询", notes = "根据标题查询自定义表单")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "title", value = "标题", required = true, paramType = "path", dataType = "String"),
    })
    @GetMapping("/{title}")
    public PtResult<LmsForm> getByTitle(@PathVariable("title") String title) {
        return success(lmsFormService.getByTitle(title));
    }

    @ApiOperation(value = "查询列表", notes = "根据标题查询自定义表单列表")
    @GetMapping("/list")
    public PtResult<List<LmsForm>> listByTitle(String title) {
        return success(lmsFormService.listByTitle(title));
    }
}
