package com.patzn.lims.res.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.SuperController;
import com.patzn.lims.res.entity.LmsLabel;
import com.patzn.lims.res.service.ILmsLabelService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 标签配置库 前端控制器
 * </p>
 *
 * @author zhaokai
 * @since 2019-08-26
 */
@Api(description = "标签配置库")
@RestController
@RequestMapping("/v1/label")
public class LmsLabelController extends SuperController {

    @Autowired
    private ILmsLabelService lmsLabelService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<Page<LmsLabel>> getPage(LmsLabel lmsLabel) {
        return success(lmsLabelService.page(getPage(), lmsLabel));
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsLabel>> getList(LmsLabel lmsLabel) {
        return success(lmsLabelService.list(lmsLabel));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    public PtResult<LmsLabel> get(@PathVariable("id") Long id) {
        return success(lmsLabelService.getById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsLabel lmsLabel) {
        lmsLabel.setId(id);
        return success(lmsLabelService.updateById(lmsLabel));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/add_or_update")
    public PtResult<Boolean> add(LmsLabel label) {
        return success(lmsLabelService.saveOrUpdateObj(label, getAccount()));
    }

    @ApiOperation(value = "根据标签类型查询标签代码", notes = "根据标签类型查询标签代码")
    @PostMapping("/search")
    public PtResult<String> search(Integer type) {
        return success(lmsLabelService.search(type, getAccount()));
    }


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @DeleteMapping("/")
    public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsLabelService.remove( Wrappers.<LmsLabel>query().in("id", ids)));
    }

}
