package com.patzn.lims.res.controller;

import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.SuperController;
import com.patzn.lims.res.entity.LmsOptionResult;
import com.patzn.lims.res.service.ILmsOptionResultService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 问题结果表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-05-24
 */
@Api(description = "问题结果表")
@RestController
@RequestMapping("/v1/options_result")
public class LmsOptionResultController extends SuperController {

    @Autowired
    private ILmsOptionResultService lmsOptionsResultService;


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    public PtResult<LmsOptionResult> get(@PathVariable("id") Long id) {
        return success(lmsOptionsResultService.getById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsOptionResult lmsOptionResult) {
        lmsOptionResult.setId(id);
        return success(lmsOptionsResultService.updateById(lmsOptionResult));
	}


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
	public PtResult<Boolean> add(LmsOptionResult lmsOptionResult) {
        return success(lmsOptionsResultService.save(lmsOptionResult));
	}

}
