package com.patzn.lims.res.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.SuperController;
import com.patzn.lims.res.dto.LmsCompareDifferentDTO;
import com.patzn.lims.res.entity.LmsProperty;
import com.patzn.lims.res.service.ILmsPropertyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * ${table.comment} 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-06-21
 */
@Api(description = "信息修改对比")
@RestController
@RequestMapping("/v1/property")
public class LmsPropertyController extends SuperController {

    @Autowired
    private ILmsPropertyService lmsPropertyService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<Page<LmsProperty>> getPage(LmsProperty lmsProperty) {
        return success(lmsPropertyService.page(getPage(), lmsProperty));
	}


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsProperty>> getList(LmsProperty lmsProperty) {
        return success(lmsPropertyService.list(lmsProperty));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    public PtResult<LmsProperty> get(@PathVariable("id") Long id) {
        return success(lmsPropertyService.getById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsProperty lmsProperty) {
        lmsProperty.setId(id);
        return success(lmsPropertyService.updateById(lmsProperty));
	}


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
	public PtResult<Boolean> add(LmsProperty lmsProperty) {
        return success(lmsPropertyService.save(lmsProperty));
	}


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
	@DeleteMapping("/")
	public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsPropertyService.remove( Wrappers.<LmsProperty>query().in("id", ids)));
	}



    @ApiOperation(value = "对象信息对比", notes = "对象信息对比")
    @PostMapping("/obj_compare")
    public PtResult<String> getCompareDifferent(@RequestBody LmsCompareDifferentDTO dto) {
        return success(lmsPropertyService.getCompareDifferent(dto.getView(), dto.getOld(), dto.getType(), dto.getTitle()));
    }
}
