package com.patzn.lims.res.controller;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.SuperController;
import com.patzn.lims.res.entity.LmsSatisfactionItem;
import com.patzn.lims.res.vo.LmsSatisfactionItemIVO;
import com.patzn.lims.res.service.ILmsSatisfactionItemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 客户满意度调查项目表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-07-18
 */
@Api(description = "客户满意度调查项目表")
@RestController
@RequestMapping("/v1/satisfaction_item")
public class LmsSatisfactionItemController extends SuperController {

    @Autowired
    private ILmsSatisfactionItemService lmsSatisfactionItemService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<Page<LmsSatisfactionItemIVO>> getPage(LmsSatisfactionItemIVO lmsSatisfactionItem) {
        return success(lmsSatisfactionItemService.page(getPage(), lmsSatisfactionItem));
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsSatisfactionItem>> getList(LmsSatisfactionItem lmsSatisfactionItem) {
        return success(lmsSatisfactionItemService.list(lmsSatisfactionItem));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    public PtResult<LmsSatisfactionItemIVO> get(@PathVariable("id") Long id) {
        return success(getDto(lmsSatisfactionItemService.getById(id)));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsSatisfactionItem lmsSatisfactionItem) {
        lmsSatisfactionItem.setId(id);
        return success(lmsSatisfactionItemService.updateSatisfactionById(lmsSatisfactionItem));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    public PtResult<Boolean> add(LmsSatisfactionItem lmsSatisfactionItem) {
        return success(lmsSatisfactionItemService.saveSatisfaction(lmsSatisfactionItem));
    }


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @DeleteMapping("/")
    public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsSatisfactionItemService.remove( Wrappers.<LmsSatisfactionItem>query().in("id", ids)));
    }


    private LmsSatisfactionItemIVO getDto(LmsSatisfactionItem entity) {
        LmsSatisfactionItemIVO dto = new LmsSatisfactionItemIVO();
        if (null != entity.getId()) {
            dto.setId(entity.getId());
        }
        if (null != entity.getPid()) {
            dto.setPid(entity.getPid());
            LmsSatisfactionItem parent = lmsSatisfactionItemService.getById(entity.getPid());
            if (null != parent) {
                dto.setPName(parent.getName());
            }
        }
        if (null != entity.getName()) {
            dto.setName(entity.getName());
        }
        if (null != entity.getRemark()) {
            dto.setRemark(entity.getRemark());
        }
        return dto;
    }

}
